/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.basic;

import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ContentDrag;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.ViewState;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.action.WindowControl;
import org.nakedobjects.nos.client.dnd.basic.SubviewIconSpecification;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Padding;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.view.simple.AbstractView;

public class MinimizedView
extends AbstractView {
    private static final int BORDER_WIDTH = 5;
    private WindowControl[] controls;
    private View iconView;
    private final View minimizedView;

    public MinimizedView(View viewToMinimize) {
        super(viewToMinimize.getContent(), new Specification(), null);
        this.minimizedView = viewToMinimize;
        this.iconView = new SubviewIconSpecification().createView(viewToMinimize.getContent(), null);
        this.iconView.setParent(this);
        this.controls = new WindowControl[]{new RestoreWindowControl((View)this), new CloseWindowControl((View)this)};
    }

    public void debug(DebugString debug) {
        super.debug(debug);
        debug.appendln("minimized view", (Object)this.minimizedView);
        debug.appendln();
        debug.appendln("icon size", (Object)this.iconView.getSize());
        debug.append((Object)this.iconView);
    }

    public void dispose() {
        super.dispose();
        this.iconView.dispose();
    }

    public Drag dragStart(DragStart drag) {
        if (this.iconView.getBounds().contains(drag.getLocation())) {
            drag.subtract(5, 5);
            return this.iconView.dragStart(drag);
        }
        return super.dragStart(drag);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        Size size = this.getSize();
        int width = size.getWidth();
        int height = size.getHeight();
        int left = 3;
        int top = 3;
        boolean hasFocus = this.containsFocus();
        Color lightColor = hasFocus ? Toolkit.getColor("secondary1") : Toolkit.getColor("secondary2");
        canvas.clearBackground(this, Toolkit.getColor("background.window"));
        canvas.drawRectangle(1, 0, width - 2, height, lightColor);
        canvas.drawRectangle(0, 1, width, height - 2, lightColor);
        for (int i = 2; i < left; ++i) {
            canvas.drawRectangle(i, i, width - 2 * i, height - 2 * i, lightColor);
        }
        ViewState state = this.getState();
        if (state.isActive()) {
            int i = left;
            canvas.drawRectangle(i, top, width - 2 * i, height - 2 * i - top, Toolkit.getColor("active"));
        }
        int bw = this.controls[0].getLocation().getX() - 3;
        canvas.drawSolidRectangle(bw, top, width - bw - 3, height - top * 2, Toolkit.getColor("secondary3"));
        canvas.drawLine(bw - 1, top, bw - 1, height - top * 2, lightColor);
        for (int i = 0; this.controls != null && i < this.controls.length; ++i) {
            Canvas controlCanvas = canvas.createSubcanvas(this.controls[i].getBounds());
            this.controls[i].draw(controlCanvas);
        }
        Canvas c = canvas.createSubcanvas(this.iconView.getBounds());
        this.iconView.draw(c);
    }

    public Size getMaximumSize() {
        Size size = new Size();
        size.extendWidth(5);
        Size iconMaximumSize = this.iconView.getMaximumSize();
        size.extendWidth(iconMaximumSize.getWidth());
        size.extendHeight(iconMaximumSize.getHeight());
        size.ensureHeight(13);
        size.extendHeight(5);
        size.extendHeight(5);
        size.extendWidth(HPADDING);
        size.extendWidth(this.controls.length * (15 + HPADDING));
        size.extendWidth(5);
        return size;
    }

    public Padding getPadding() {
        return new Padding(5, 5, 5, 5);
    }

    public void layout(Size maximumSize) {
        Size size = this.getMaximumSize();
        this.layoutControls(size.getWidth());
        size.contractWidth(10);
        size.contractWidth(HPADDING);
        size.contractWidth(this.controls.length * (15 + HPADDING));
        size.contractHeight(10);
        this.iconView.setLocation(new Location(5, 5));
        this.iconView.setSize(size);
    }

    private void layoutControls(int width) {
        int widthControl = 15 + HPADDING;
        int x = width - 5 + HPADDING;
        x -= widthControl * this.controls.length;
        int y = 5;
        for (int i = 0; i < this.controls.length; ++i) {
            this.controls[i].setSize(this.controls[i].getMaximumSize());
            this.controls[i].setLocation(new Location(x, y));
            x += widthControl;
        }
    }

    private void restore() {
        Workspace workspace = this.getWorkspace();
        View[] views = workspace.getSubviews();
        for (int i = 0; i < views.length; ++i) {
            if (views[i] != this) continue;
            this.dispose();
            this.minimizedView.setParent(workspace);
            workspace.addView(this.minimizedView);
            workspace.invalidateLayout();
            return;
        }
    }

    private void close() {
        Workspace workspace = this.getWorkspace();
        View[] views = workspace.getSubviews();
        for (int i = 0; i < views.length; ++i) {
            if (views[i] != this) continue;
            this.dispose();
            this.minimizedView.setParent(workspace);
            workspace.invalidateLayout();
            workspace.addView(this.minimizedView);
            this.minimizedView.dispose();
            return;
        }
    }

    public void removeView(View view) {
        if (view != this.iconView) {
            throw new NakedObjectRuntimeException("No view " + view + " in " + this);
        }
        this.iconView = null;
    }

    public void secondClick(Click click) {
        this.restore();
    }

    public ViewAreaType viewAreaType(Location location) {
        location.subtract(5, 5);
        return this.iconView.viewAreaType(location);
    }

    public void viewMenuOptions(UserActionSet options) {
        options.add(new AbstractUserAction("Restore"){

            public void execute(Workspace workspace, View view, Location at) {
                MinimizedView.this.restore();
            }
        });
        super.viewMenuOptions(options);
    }

    public void firstClick(Click click) {
        View button = this.overControl(click.getLocation());
        if (button != null) {
            button.firstClick(click);
        }
    }

    private View overControl(Location location) {
        for (int i = 0; i < this.controls.length; ++i) {
            WindowControl control = this.controls[i];
            if (!control.getBounds().contains(location)) continue;
            return control;
        }
        return null;
    }

    public void dragIn(ContentDrag drag) {
        if (this.iconView.getBounds().contains(drag.getTargetLocation())) {
            drag.subtract(5, 5);
            this.iconView.dragIn(drag);
        }
    }

    public void dragOut(ContentDrag drag) {
        if (this.iconView.getBounds().contains(drag.getTargetLocation())) {
            drag.subtract(5, 5);
            this.iconView.dragOut(drag);
        }
    }

    public View identify(Location location) {
        if (this.iconView.getBounds().contains(location)) {
            location.subtract(5, 5);
            return this.iconView.identify(location);
        }
        return this;
    }

    public void drop(ContentDrag drag) {
        if (this.iconView.getBounds().contains(drag.getTargetLocation())) {
            drag.subtract(5, 5);
            this.iconView.drop(drag);
        }
    }

    private static class Specification
    implements ViewSpecification {
        private Specification() {
        }

        public boolean canDisplay(Content content) {
            return false;
        }

        public View createView(Content content, ViewAxis axis) {
            return null;
        }

        public String getName() {
            return "minimized view";
        }

        public boolean isAligned() {
            return false;
        }

        public boolean isOpen() {
            return false;
        }

        public boolean isReplaceable() {
            return false;
        }

        public boolean isSubView() {
            return false;
        }
    }

    private class RestoreWindowControl
    extends WindowControl {
        public RestoreWindowControl(View target) {
            super(new UserAction(){

                public Consent disabled(View view) {
                    return Allow.DEFAULT;
                }

                public void execute(Workspace workspace, View view, Location at) {
                    ((MinimizedView)view).restore();
                }

                public String getDescription(View view) {
                    return "Restore " + view.getSpecification().getName() + " to normal size";
                }

                public String getHelp(View view) {
                    return null;
                }

                public String getName(View view) {
                    return "Restore view";
                }

                public NakedObjectAction.Type getType() {
                    return USER;
                }
            }, target);
        }

        public void draw(Canvas canvas) {
            int x = 0;
            int y = 0;
            canvas.drawRectangle(x + 1, y + 1, 14, 12, Toolkit.getColor("black"));
            canvas.drawLine(x + 2, y + 2, x + 15 - 2, y + 2, Toolkit.getColor("black"));
            canvas.drawLine(x + 2, y + 3, x + 15 - 2, y + 3, Toolkit.getColor("black"));
        }
    }

    private class CloseWindowControl
    extends WindowControl {
        public CloseWindowControl(View target) {
            super(new UserAction(){

                public Consent disabled(View view) {
                    return Allow.DEFAULT;
                }

                public void execute(Workspace workspace, View view, Location at) {
                    ((MinimizedView)view).close();
                }

                public String getDescription(View view) {
                    return "Close " + view.getSpecification().getName();
                }

                public String getHelp(View view) {
                    return null;
                }

                public String getName(View view) {
                    return "Close view";
                }

                public NakedObjectAction.Type getType() {
                    return USER;
                }
            }, target);
        }

        public void draw(Canvas canvas) {
            int x = 0;
            int y = 0;
            Color crossColor = Toolkit.getColor("black");
            canvas.drawLine(x + 4, y + 3, x + 10, y + 9, crossColor);
            canvas.drawLine(x + 5, y + 3, x + 11, y + 9, crossColor);
            canvas.drawLine(x + 10, y + 3, x + 4, y + 9, crossColor);
            canvas.drawLine(x + 11, y + 3, x + 5, y + 9, crossColor);
        }
    }
}

