/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.basic;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.FocusManager;
import org.nakedobjects.nos.client.dnd.KeyboardAction;
import org.nakedobjects.nos.client.dnd.MenuOptions;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.content.AbstractContent;
import org.nakedobjects.nos.client.dnd.debug.DebugOption;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Image;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Padding;
import org.nakedobjects.nos.client.dnd.drawing.Shape;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.drawing.Text;
import org.nakedobjects.nos.client.dnd.focus.SubviewFocusManager;
import org.nakedobjects.nos.client.dnd.view.simple.AbstractView;

public class PopupMenu
extends AbstractView {
    private static final UserAction DEBUG_OPTION = new DebugOption();
    private static final Logger LOG = Logger.getLogger(PopupMenu.class);
    private Color backgroundColor;
    private Bounds coreSize;
    private View forView;
    private Item[] items = new Item[0];
    private int optionIdentified;
    private FocusManager simpleFocusManager;
    private View submenu;
    private Vector options = new Vector();

    public PopupMenu() {
        super(null, new PopupSpecification(), null);
        this.setContent(new PopupContent());
        this.simpleFocusManager = new SubviewFocusManager(this);
    }

    private void addItems(View target, UserAction[] options, int len, Vector list, NakedObjectAction.Type type) {
        int initialSize = list.size();
        for (int i = 0; i < len; ++i) {
            if (options[i].getType() != type) continue;
            if (initialSize > 0 && list.size() == initialSize) {
                list.addElement(Item.createDivider());
            }
            list.addElement(Item.createOption(options[i], null, target, this.getLocation()));
        }
    }

    protected Color backgroundColor() {
        return this.backgroundColor;
    }

    public Consent canChangeValue() {
        return Veto.DEFAULT;
    }

    public boolean canFocus() {
        return true;
    }

    public void debug(DebugString debug) {
        super.debug(debug);
        debug.appendTitle("Submenu");
        debug.append((Object)this.submenu);
        debug.append((Object)"\n");
    }

    protected Color disabledColor() {
        return Toolkit.getColor("menu.disabled");
    }

    public void dispose() {
        if (this.getParent() == null) {
            super.dispose();
            this.getViewManager().clearOverlayView(this);
        } else {
            this.getParent().dispose();
        }
    }

    public void draw(Canvas canvas) {
        int width = this.coreSize.getWidth();
        int height = this.coreSize.getHeight();
        canvas.drawSolidRectangle(0, 0, width, height, this.backgroundColor);
        canvas.draw3DRectangle(0, 0, width, height, this.backgroundColor, true);
        int itemHeight = this.style().getLineHeight() + VPADDING;
        int baseLine = this.style().getAscent() + this.getPadding().getTop() + 1;
        int left = this.getPadding().getLeft();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i].isBlank) {
                int y = baseLine - this.style().getAscent() / 2;
                canvas.drawLine(1, y, width - 2, y, this.backgroundColor.brighter());
                canvas.drawLine(1, y - 1, width - 2, y - 1, this.backgroundColor.darker());
            } else {
                Color color;
                if (this.items[i].isDisabled || this.items[i].action == null) {
                    color = this.disabledColor();
                } else if (this.getOption() == i) {
                    int top = this.getPadding().getTop() + i * itemHeight;
                    int depth = this.style().getLineHeight() + 2;
                    canvas.drawSolidRectangle(2, top, width - 4, depth, this.backgroundColor.darker());
                    canvas.draw3DRectangle(2, top, width - 4, depth + 1, this.backgroundColor.brighter(), false);
                    color = this.reversedColor();
                } else {
                    color = this.normalColor();
                }
                canvas.drawText(this.items[i].name, left, baseLine, color, this.style());
                if (this.items[i].action instanceof UserActionSet) {
                    Shape arrow = new Shape(0, 0);
                    arrow.extendsLine(4, 4);
                    arrow.extendsLine(-4, 4);
                    canvas.drawSolidShape(arrow, width - 10, baseLine - 8, color);
                }
            }
            baseLine += itemHeight;
        }
        if (this.submenu != null) {
            Canvas submenuCanvas = canvas.createSubcanvas(this.submenu.getBounds());
            this.submenu.draw(submenuCanvas);
        }
    }

    public void firstClick(Click click) {
        if (this.coreSize.contains(click.getLocation())) {
            if (click.button1() || click.button3()) {
                this.mouseMoved(click.getLocation());
                this.invoke();
            }
        } else if (this.submenu != null) {
            click.subtract(this.submenu.getLocation());
            this.submenu.firstClick(click);
        }
    }

    public void focusLost() {
    }

    public void focusReceived() {
    }

    private Size getCoreRequiredSize() {
        Size size = new Size();
        for (int i = 0; i < this.items.length; ++i) {
            int itemWidth = this.items[i].isBlank ? 0 : this.style().stringWidth(this.items[i].name);
            size.ensureWidth(itemWidth);
            size.extendHeight(this.style().getLineHeight() + VPADDING);
        }
        size.extend(this.getPadding());
        size.extendWidth(HPADDING * 2);
        return size;
    }

    public FocusManager getFocusManager() {
        return this.simpleFocusManager;
    }

    public Size getMaximumSize() {
        Size size = this.getCoreRequiredSize();
        if (this.submenu != null) {
            Size subviewSize = this.submenu.getMaximumSize();
            size.extendWidth(subviewSize.getWidth());
            size.ensureHeight(this.submenu.getLocation().getY() + subviewSize.getHeight());
        }
        return size;
    }

    public int getOption() {
        return this.optionIdentified;
    }

    public int getOptionCount() {
        return this.items.length;
    }

    public Padding getPadding() {
        Padding in = super.getPadding();
        in.extendTop(VPADDING);
        in.extendBottom(VPADDING);
        in.extendLeft(HPADDING + 5);
        in.extendRight(HPADDING + 5);
        return in;
    }

    public Workspace getWorkspace() {
        return this.forView.getWorkspace();
    }

    public boolean hasFocus() {
        return false;
    }

    private void invoke() {
        int option = this.getOption();
        Item item = this.items[option];
        if (item.isBlank || item.action == null || item.action.disabled(this.forView).isVetoed()) {
            return;
        }
        if (item.action instanceof UserActionSet) {
            this.markDamaged();
            int itemHeight = this.style().getLineHeight() + VPADDING;
            Location menuLocation = new Location(this.coreSize.getWidth() - 4, itemHeight * option);
            this.submenu = new PopupMenu();
            this.submenu.setParent(this);
            ((PopupMenu)this.submenu).show(this.forView, ((UserActionSet)item.action).getMenuOptions(), this.backgroundColor);
            this.submenu.setLocation(menuLocation);
            this.invalidateLayout();
            Size size = this.getMaximumSize();
            this.setSize(size);
            this.layout(size);
            this.markDamaged();
        } else {
            Workspace workspace = this.getWorkspace();
            Location location = new Location(this.getAbsoluteLocation());
            location.subtract(workspace.getView().getAbsoluteLocation());
            Padding padding = workspace.getView().getPadding();
            location.move(-padding.getLeft(), -padding.getTop());
            location.move(30, 0);
            this.dispose();
            LOG.debug((Object)("execute " + item.name + " on " + this.forView + " in " + workspace));
            item.action.execute(workspace, this.forView, location);
        }
    }

    public void keyPressed(KeyboardAction key) {
        block6: {
            int keyCode;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    if (this.submenu == null) break block7;
                                    this.submenu.keyPressed(key);
                                    break block6;
                                }
                                keyCode = key.getKeyCode();
                                if (keyCode != 27) break block8;
                                if (this.getParent() == null) {
                                    this.dispose();
                                } else {
                                    this.markDamaged();
                                    ((PopupMenu)this.getParent()).submenu = null;
                                }
                                key.consume();
                                break block6;
                            }
                            if (keyCode != 10) break block9;
                            key.consume();
                            this.invoke();
                            break block6;
                        }
                        if (this.getParent() == null || keyCode != 37) break block10;
                        this.markDamaged();
                        ((PopupMenu)this.getParent()).submenu = null;
                        key.consume();
                        break block6;
                    }
                    if (keyCode != 39 || !(this.items[this.getOption()].action instanceof UserActionSet)) break block11;
                    key.consume();
                    this.invoke();
                    break block6;
                }
                if (keyCode != 38) break block12;
                key.consume();
                if (this.optionIdentified == 0) {
                    this.optionIdentified = this.items.length;
                }
                for (int i = this.optionIdentified - 1; i >= 0; --i) {
                    if (this.items[i].isBlank || this.items[i].isDisabled) continue;
                    this.setOption(i);
                    break block6;
                }
                break block6;
            }
            if (keyCode != 40) break block6;
            key.consume();
            if (this.optionIdentified == this.items.length - 1) {
                this.optionIdentified = -1;
            }
            for (int i = this.optionIdentified + 1; i < this.items.length; ++i) {
                if (this.items[i].isBlank || this.items[i].isDisabled) continue;
                this.setOption(i);
                break;
            }
        }
    }

    public void keyReleased(int keyCode, int modifiers) {
    }

    public void keyTyped(char keyCode) {
    }

    public void layout(Size maximumSize) {
        if (this.submenu != null) {
            this.submenu.layout(maximumSize);
        }
        this.setSize(this.getMaximumSize());
        this.coreSize = new Bounds(this.getCoreRequiredSize());
    }

    public View makeView(Naked object, NakedObjectField field) throws CloneNotSupportedException {
        throw new RuntimeException();
    }

    public void markDamaged() {
        if (this.getParent() == null) {
            super.markDamaged();
        } else {
            this.getParent().markDamaged();
        }
    }

    public void mouseMoved(Location at) {
        if (this.coreSize.contains(at)) {
            int option = (at.getY() - this.getPadding().getTop()) / (this.style().getLineHeight() + VPADDING);
            option = Math.max(option, 0);
            if ((option = Math.min(option, this.items.length - 1)) >= 0 && this.optionIdentified != option) {
                this.setOption(option);
                this.markDamaged();
            }
        } else if (this.submenu != null) {
            at.subtract(this.submenu.getLocation());
            this.submenu.mouseMoved(at);
        }
    }

    protected Color normalColor() {
        return Toolkit.getColor("menu.normal");
    }

    private String changeStatus(View over, boolean forView, boolean includeExploration, boolean includeDebug) {
        StringBuffer status = new StringBuffer("Menu for ");
        if (forView) {
            status.append("view ");
            status.append(over.getSpecification().getName());
        } else {
            status.append("object");
            Content content = over.getContent();
            if (content != null) {
                status.append(" '");
                status.append(content.title());
                status.append("'");
            }
        }
        if (includeDebug || includeExploration) {
            status.append(" (includes ");
            if (includeExploration) {
                status.append("exploration");
            }
            if (includeDebug) {
                if (includeExploration) {
                    status.append(" & ");
                }
                status.append("debug");
            }
            status.append(" options)");
        }
        return status.toString();
    }

    protected Color reversedColor() {
        return Toolkit.getColor("menu.reversed");
    }

    public void setOption(int option) {
        if (option != this.optionIdentified) {
            this.optionIdentified = option;
            this.markDamaged();
            this.updateFeedback();
        }
    }

    private void updateFeedback() {
        Item item = this.items[this.optionIdentified];
        if (item.isBlank) {
            this.getFeedbackManager().clearAction();
        } else if (item.reason == "") {
            this.getFeedbackManager().setAction(item.description == null ? "" : item.description);
        } else {
            this.getFeedbackManager().setAction(item.reason);
        }
    }

    public void show(View over, boolean forView, boolean includeDebug, boolean includeExploration) {
        boolean withExploration = this.getViewManager().isRunningAsExploration() && includeExploration;
        UserActionSet optionSet = new UserActionSet(withExploration, includeDebug, UserAction.USER);
        if (forView) {
            over.viewMenuOptions(optionSet);
        } else {
            over.contentMenuOptions(optionSet);
        }
        optionSet.add(DEBUG_OPTION);
        Enumeration e = this.options.elements();
        while (e.hasMoreElements()) {
            MenuOptions element = (MenuOptions)e.nextElement();
            element.menuOptions(optionSet);
        }
        this.show(over, optionSet.getMenuOptions(), optionSet.getColor());
        this.getViewManager().setOverlayView(this);
        String status = this.changeStatus(over, forView, withExploration, includeDebug);
        this.getFeedbackManager().setViewDetail(status);
        this.updateFeedback();
    }

    private void show(View target, UserAction[] options, Color color) {
        this.forView = target;
        this.optionIdentified = 0;
        this.backgroundColor = color;
        int len = options.length;
        if (len == 0) {
            this.items = new Item[]{Item.createNoOption()};
        } else {
            Vector list = new Vector();
            this.addItems(target, options, len, list, UserAction.USER);
            this.addItems(target, options, len, list, UserAction.EXPLORATION);
            this.addItems(target, options, len, list, UserAction.DEBUG);
            this.items = new Item[list.size()];
            list.copyInto(this.items);
        }
    }

    protected Text style() {
        return Toolkit.getText("menu");
    }

    public String toString() {
        return "PopupMenu [location=" + this.getLocation() + ",item=" + this.optionIdentified + ",itemCount=" + (this.items == null ? 0 : this.items.length) + "]";
    }

    protected boolean transparentBackground() {
        return false;
    }

    public void addMenuOptions(MenuOptions options) {
        this.options.addElement(options);
    }

    private static class PopupSpecification
    implements ViewSpecification {
        private PopupSpecification() {
        }

        public boolean canDisplay(Content content) {
            return false;
        }

        public View createView(Content content, ViewAxis axis) {
            return null;
        }

        public String getName() {
            return "Popup Menu";
        }

        public boolean isAligned() {
            return false;
        }

        public boolean isOpen() {
            return true;
        }

        public boolean isReplaceable() {
            return false;
        }

        public boolean isSubView() {
            return false;
        }
    }

    private class PopupContent
    extends AbstractContent {
        public Consent canDrop(Content sourceContent) {
            return Veto.DEFAULT;
        }

        public void debugDetails(DebugString debug) {
        }

        public Naked drop(Content sourceContent) {
            return null;
        }

        public String getDescription() {
            int optionNo = PopupMenu.this.getOption();
            return ((PopupMenu)PopupMenu.this).items[optionNo].description;
        }

        public String getHelp() {
            int optionNo = PopupMenu.this.getOption();
            return PopupMenu.this.items[optionNo].getHelp();
        }

        public String getIconName() {
            return null;
        }

        public Image getIconPicture(int iconHeight) {
            return null;
        }

        public String getId() {
            return null;
        }

        public Naked getNaked() {
            return null;
        }

        public boolean isOptionEnabled() {
            return false;
        }

        public NakedObjectSpecification getSpecification() {
            return null;
        }

        public boolean isTransient() {
            return false;
        }

        public void parseTextEntry(String entryText) {
        }

        public String title() {
            int optionNo = PopupMenu.this.getOption();
            return ((PopupMenu)PopupMenu.this).items[optionNo].name;
        }

        public Naked[] getOptions() {
            return null;
        }
    }

    private static class Item {
        UserAction action;
        String description;
        boolean isBlank;
        boolean isDisabled;
        String name;
        String reason;
        View view;

        public static Item createDivider() {
            Item item = new Item();
            item.isBlank = true;
            return item;
        }

        public static Item createNoOption() {
            Item item = new Item();
            item.name = "no options";
            return item;
        }

        public static Item createOption(UserAction action, Object object, View view, Location location) {
            Item item = new Item();
            if (action == null) {
                item.isBlank = true;
            } else {
                item.isBlank = false;
                item.action = action;
                item.view = view;
                item.name = action.getName(view);
                item.description = action.getDescription(view);
                Consent disabled = action.disabled(view);
                item.isDisabled = disabled.isVetoed();
                item.reason = disabled.getReason();
            }
            return item;
        }

        private Item() {
        }

        public String getHelp() {
            return this.action.getHelp(this.view);
        }

        public String toString() {
            return this.isBlank ? "NONE" : this.name + " " + (this.isDisabled ? "DISABLED " : " " + this.action);
        }
    }
}

