/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.basic;

import org.apache.log4j.Logger;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.InternalDrag;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.basic.ResizeDrag;
import org.nakedobjects.nos.client.dnd.basic.ViewResizeOutline;
import org.nakedobjects.nos.client.dnd.border.AbstractBorder;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;

public abstract class ResizeBorder
extends AbstractBorder {
    private static final Logger LOG = Logger.getLogger(ResizeBorder.class);
    private static final Logger UI_LOG = Logger.getLogger((String)("ui." + ResizeBorder.class.getName()));
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int UP = 4;
    public static final int DOWN = 8;
    private int width;
    private int height;
    private int requiredDirection;
    private int allowDirections;
    protected boolean resizing;
    private int onBorder;

    public ResizeBorder(View view, int allowDirections, int width, int minimumWidth) {
        super(view);
        this.allowDirections = allowDirections;
        this.top = this.canExtend(4) ? width : minimumWidth;
        this.bottom = this.canExtend(8) ? width : minimumWidth;
        this.left = this.canExtend(1) ? width : minimumWidth;
        this.right = this.canExtend(2) ? width : minimumWidth;
    }

    protected void debugDetails(DebugString debug) {
        super.debugDetails(debug);
        debug.append((Object)("\n           width " + (this.width == 0 ? "no change" : Integer.toString(this.width))));
        debug.append((Object)("\n           height " + (this.height == 0 ? "no change" : Integer.toString(this.height))));
        debug.append((Object)("\n           resizable " + (this.canExtend(4) ? "Up " : "") + (this.canExtend(8) ? "Down " : "") + (this.canExtend(1) ? "Left " : "") + (this.canExtend(2) ? "Right " : "")));
    }

    public void draw(Canvas canvas) {
        Size size = this.getSize();
        int width = size.getWidth();
        int height = size.getHeight();
        this.drawResizeBorder(canvas, size);
        Canvas subCanvas = canvas.createSubcanvas(this.left, this.top, width - this.left - this.right, height - this.top - this.bottom);
        this.wrappedView.draw(subCanvas);
    }

    protected abstract void drawResizeBorder(Canvas var1, Size var2);

    public ViewAreaType viewAreaType(Location mouseLocation) {
        if (this.isOnBorder()) {
            return ViewAreaType.INTERNAL;
        }
        return super.viewAreaType(mouseLocation);
    }

    public void viewMenuOptions(UserActionSet menuOptions) {
        super.viewMenuOptions(menuOptions);
        menuOptions.add(new AbstractUserAction("Clear resizing"){

            public void execute(Workspace workspace, View view, Location at) {
                ResizeBorder.this.width = 0;
                ResizeBorder.this.height = 0;
                ResizeBorder.this.invalidateLayout();
            }
        });
    }

    public Drag dragStart(DragStart drag) {
        Location location = drag.getLocation();
        if (this.overBorder(location)) {
            this.requiredDirection = this.onBorder(location);
            if (this.requiredDirection > 0) {
                return new ResizeDrag(this, new Bounds(this.getAbsoluteLocation(), this.getView().getSize()), this.requiredDirection);
            }
            return null;
        }
        return super.dragStart(drag);
    }

    public void drag(InternalDrag drag) {
        ViewResizeOutline outline = (ViewResizeOutline)drag.getOverlay();
        if (outline == null) {
            super.drag(drag);
        }
    }

    public void dragTo(InternalDrag drag) {
        this.getFeedbackManager().showDefaultCursor();
        ViewResizeOutline outline = (ViewResizeOutline)drag.getOverlay();
        if (outline != null) {
            this.resizing = false;
            this.onBorder = 0;
            if (this.requiredDirection == 4 || this.requiredDirection == 8) {
                this.width = outline.getSize().getWidth();
            }
            if (this.requiredDirection == 2 || this.requiredDirection == 8) {
                this.height = outline.getSize().getHeight();
            }
            LOG.debug((Object)("resizing view " + this.width + "," + this.height));
            this.invalidateLayout();
        } else {
            super.dragTo(drag);
        }
    }

    public Size getRequiredSize(Size maximumSize) {
        maximumSize.contract(this.getLeft() + this.getRight(), this.getTop() + this.getBottom());
        if (this.width > 0 && maximumSize.getWidth() > this.width) {
            maximumSize.setWidth(this.width);
        }
        if (this.height > 0 && maximumSize.getHeight() > this.height) {
            maximumSize.setHeight(this.height);
        }
        Size size = this.wrappedView.getRequiredSize(maximumSize);
        size.extend(this.getLeft() + this.getRight(), this.getTop() + this.getBottom());
        if (this.width > 0) {
            size.setWidth(this.width);
        }
        if (this.height > 0) {
            size.setHeight(this.height);
        }
        return size;
    }

    public void mouseMoved(Location at) {
        int onBorder = this.onBorder(at);
        if (this.onBorder != onBorder) {
            switch (onBorder) {
                case 4: {
                    this.getFeedbackManager().showResizeRightCursor();
                    this.resizing = true;
                    this.markDamaged();
                    break;
                }
                case 2: {
                    this.getFeedbackManager().showResizeDownCursor();
                    this.resizing = true;
                    this.markDamaged();
                    break;
                }
                case 8: {
                    this.getFeedbackManager().showResizeDownRightCursor();
                    this.resizing = true;
                    this.markDamaged();
                    break;
                }
                default: {
                    this.getFeedbackManager().showDefaultCursor();
                    super.mouseMoved(at);
                    this.resizing = false;
                    this.markDamaged();
                }
            }
            UI_LOG.debug((Object)("on resize border " + onBorder + " " + this.resizing));
        }
        this.onBorder = onBorder;
    }

    public void exited() {
        this.getFeedbackManager().showDefaultCursor();
        this.resizing = false;
        this.onBorder = 0;
        this.markDamaged();
        UI_LOG.debug((Object)("off resize border " + this.onBorder + " " + this.resizing));
        super.exited();
    }

    private int onBorder(Location at) {
        boolean bottom;
        Bounds area = this.contentArea();
        boolean right = this.canExtend(2) && at.getX() >= area.getWidth() && at.getX() <= area.getWidth() + this.getRight();
        boolean bl = bottom = this.canExtend(8) && at.getY() >= area.getHeight() && at.getY() <= area.getHeight() + this.getBottom();
        int status = right && bottom ? 8 : (right ? 4 : (bottom ? 2 : 0));
        return status;
    }

    private boolean canExtend(int extend) {
        return (extend & this.allowDirections) == extend;
    }
}

