/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.basic;

import org.nakedobjects.nos.client.dnd.InternalDrag;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Viewer;
import org.nakedobjects.nos.client.dnd.basic.ViewResizeOutline;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;

public class ResizeDrag
extends InternalDrag {
    public static final int BOTTOM = 2;
    public static final int BOTTOM_LEFT = 7;
    public static final int BOTTOM_RIGHT = 8;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int TOP = 1;
    public static final int TOP_LEFT = 5;
    public static final int TOP_RIGHT = 6;
    private final Location anchor;
    private final int direction;
    private final ViewResizeOutline overlay;
    private final View view;
    private final Size minimumSize;
    private final Size maximumSize;

    public ResizeDrag(View view, Bounds resizeArea, int direction) {
        this(view, resizeArea, direction, null, null);
    }

    public ResizeDrag(View view, Bounds resizeArea, int direction, Size minimumSize, Size maximumSize) {
        this.view = view;
        this.direction = direction;
        this.anchor = resizeArea.getLocation();
        this.minimumSize = minimumSize;
        this.maximumSize = maximumSize;
        this.overlay = new ViewResizeOutline(resizeArea);
        this.overlay.setLocation(resizeArea.getLocation());
    }

    public void cancel(Viewer viewer) {
        this.view.dragCancel(this);
    }

    public void drag(View target, Location location, int mods) {
        switch (this.direction) {
            case 1: {
                this.extendUpward(location);
                break;
            }
            case 2: {
                this.extendDownward(location);
                break;
            }
            case 3: {
                this.extendLeft(location);
                break;
            }
            case 4: {
                this.extendRight(location);
                break;
            }
            case 6: {
                this.extendRight(location);
                this.extendUpward(location);
                break;
            }
            case 8: {
                this.extendRight(location);
                this.extendDownward(location);
                break;
            }
            case 5: {
                this.extendLeft(location);
                this.extendUpward(location);
                break;
            }
            case 7: {
                this.extendLeft(location);
                this.extendDownward(location);
                break;
            }
        }
    }

    public void end(Viewer viewer) {
        this.view.dragTo(this);
        this.view.getViewManager().clearOverlayView(this.view);
    }

    private void extendDownward(Location location) {
        this.overlay.markDamaged();
        int height = location.getY() - this.anchor.getY();
        int width = this.overlay.getSize().getWidth();
        this.overlay.setSize(new Size(width, height));
        this.overlay.markDamaged();
    }

    private void extendLeft(Location location) {
        this.overlay.markDamaged();
        int height = this.overlay.getSize().getHeight();
        int width = this.anchor.getX() - location.getX();
        this.overlay.setSize(new Size(width, height));
        int x = this.anchor.getX() - width;
        int y = this.anchor.getY();
        this.overlay.setBounds(new Bounds(x, y, width, height));
        this.overlay.markDamaged();
    }

    private void extendRight(Location location) {
        this.overlay.markDamaged();
        int height = this.overlay.getSize().getHeight();
        int width = location.getX() - this.anchor.getX();
        if (this.maximumSize != null && width > this.maximumSize.getWidth()) {
            width = this.maximumSize.getWidth();
        }
        if (this.minimumSize != null && width < this.minimumSize.getWidth()) {
            width = this.minimumSize.getWidth();
        }
        this.overlay.setSize(new Size(width, height));
        this.overlay.markDamaged();
    }

    private void extendUpward(Location location) {
        this.overlay.markDamaged();
        int height = this.anchor.getY() - location.getY();
        int width = this.overlay.getSize().getWidth();
        this.overlay.setSize(new Size(width, height));
        int x = this.anchor.getX();
        int y = this.anchor.getY() - height;
        this.overlay.setBounds(new Bounds(x, y, width, height));
        this.overlay.markDamaged();
    }

    public int getDirection() {
        return this.direction;
    }

    public Location getLocation() {
        Size size = this.overlay.getSize();
        return new Location(size.getWidth(), size.getHeight());
    }

    public View getOverlay() {
        return this.overlay;
    }
}

