/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.basic;

import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewDrag;
import org.nakedobjects.nos.client.dnd.border.AbstractBorder;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Offset;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.view.simple.DragViewOutline;

public class SimpleBorder
extends AbstractBorder {
    private int handleWidth = 14;

    public SimpleBorder(View wrappedView) {
        this(1, wrappedView);
    }

    public SimpleBorder(int size, View wrappedView) {
        super(wrappedView);
        this.top = size;
        this.left = size;
        this.bottom = size;
        this.right = size + this.handleWidth;
    }

    protected void debugDetails(DebugString debug) {
        debug.append((Object)("SimpleBorder " + this.top + " pixels\n"));
        debug.append((Object)("           handle " + this.handleWidth + " pixels"));
    }

    public Drag dragStart(DragStart drag) {
        if (this.overBorder(drag.getLocation())) {
            Location location = drag.getLocation();
            DragViewOutline dragOverlay = new DragViewOutline(this.getView());
            return new ViewDrag(this, new Offset(location.getX(), location.getY()), dragOverlay);
        }
        return super.dragStart(drag);
    }

    public void entered() {
        this.getState().setContentIdentified();
        this.getState().setViewIdentified();
        this.wrappedView.entered();
        this.markDamaged();
    }

    public void exited() {
        this.getState().clearObjectIdentified();
        this.getState().clearViewIdentified();
        this.wrappedView.exited();
        this.markDamaged();
    }

    public void draw(Canvas canvas) {
        if (this.getState().isViewIdentified()) {
            Color color = Toolkit.getColor("secondary2");
            Size s = this.getSize();
            int width = s.getWidth();
            for (int i = 0; i < this.left; ++i) {
                canvas.drawRectangle(i, i, width - 2 * i - 1, s.getHeight() - 2 * i - 1, color);
            }
            int w2 = width - this.left - 2;
            int w3 = w2 - this.handleWidth;
            for (int x = w2; x > w3; x -= 2) {
                canvas.drawLine(x, this.top, x, s.getHeight() - this.top, color);
            }
        }
        super.draw(canvas);
    }

    public String toString() {
        return this.wrappedView.toString() + "/SimpleBorder";
    }
}

