/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.border;

import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.ContentDrag;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.ViewDrag;
import org.nakedobjects.nos.client.dnd.border.AbstractViewDecorator;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Padding;
import org.nakedobjects.nos.client.dnd.drawing.Size;

public class AbstractBorder
extends AbstractViewDecorator {
    protected int bottom;
    protected int left;
    private boolean onBorder;
    protected int right;
    protected int top;

    protected AbstractBorder(View view) {
        super(view);
    }

    protected Bounds contentArea() {
        return new Bounds(this.getLeft(), this.getTop(), this.getSize().getWidth() - this.getLeft() - this.getRight(), this.getSize().getHeight() - this.getTop() - this.getBottom());
    }

    public View dragFrom(Location location) {
        location.subtract(this.getLeft(), this.getTop());
        return super.dragFrom(location);
    }

    public void dragIn(ContentDrag drag) {
        drag.subtract(this.getLeft(), this.getTop());
        super.dragIn(drag);
    }

    public void dragOut(ContentDrag drag) {
        drag.subtract(this.getLeft(), this.getTop());
        super.dragOut(drag);
    }

    public Drag dragStart(DragStart drag) {
        if (this.overContent(drag.getLocation())) {
            drag.subtract(this.getLeft(), this.getTop());
            return super.dragStart(drag);
        }
        return null;
    }

    public void draw(Canvas canvas) {
        if (Toolkit.debug) {
            canvas.drawDebugOutline(new Bounds(this.getSize()), this.getBaseline(), Toolkit.getColor("debug.bounds.border"));
        }
        this.wrappedView.draw(canvas.createSubcanvas(this.getLeft(), this.getTop(), this.getSize().getWidth() - this.getRight(), this.getSize().getHeight() - this.getBottom()));
    }

    public void drop(ContentDrag drag) {
        drag.subtract(this.getLeft(), this.getTop());
        super.drop(drag);
    }

    public void drop(ViewDrag drag) {
        drag.subtract(this.getLeft(), this.getTop());
        super.drop(drag);
    }

    public void firstClick(Click click) {
        if (this.overContent(click.getLocation())) {
            click.subtract(this.getLeft(), this.getTop());
            this.wrappedView.firstClick(click);
        }
    }

    public int getBaseline() {
        return this.wrappedView.getBaseline() + this.getTop();
    }

    protected int getBottom() {
        return this.bottom;
    }

    protected int getLeft() {
        return this.left;
    }

    public Padding getPadding() {
        Padding padding = this.wrappedView.getPadding();
        padding.extendTop(this.getTop());
        padding.extendLeft(this.getLeft());
        padding.extendBottom(this.getBottom());
        padding.extendRight(this.getRight());
        return padding;
    }

    public Size getRequiredSize(Size maximumSize) {
        maximumSize.contract(this.getLeft() + this.getRight(), this.getTop() + this.getBottom());
        Size size = this.wrappedView.getRequiredSize(maximumSize);
        size.extend(this.getLeft() + this.getRight(), this.getTop() + this.getBottom());
        return size;
    }

    protected int getRight() {
        return this.right;
    }

    public Size getSize() {
        Size size = this.wrappedView.getSize();
        size.extend(this.getLeft() + this.getRight(), this.getTop() + this.getBottom());
        return size;
    }

    protected int getTop() {
        return this.top;
    }

    protected void debugDetails(DebugString debug) {
        super.debugDetails(debug);
        debug.appendln("border", (Object)(this.getTop() + "/" + this.getBottom() + " " + this.getLeft() + "/" + this.getRight() + " (top/bottom left/right)"));
        debug.appendln("contents", (Object)this.contentArea());
    }

    protected boolean overBorder(Location location) {
        return !this.contentArea().contains(location);
    }

    protected boolean overContent(Location location) {
        return this.contentArea().contains(location);
    }

    protected boolean isOnBorder() {
        return this.onBorder;
    }

    public View identify(Location location) {
        this.getViewManager().getSpy().addTrace(this, "mouse location within border", location);
        this.getViewManager().getSpy().addTrace(this, "non border area", this.contentArea());
        if (this.overBorder(location)) {
            this.getViewManager().getSpy().addTrace(this, "over border area", this.contentArea());
            return this.getView();
        }
        location.add(-this.getLeft(), -this.getTop());
        return super.identify(location);
    }

    public void mouseDown(Click click) {
        if (this.overContent(click.getLocation())) {
            click.subtract(this.getLeft(), this.getTop());
            this.wrappedView.mouseDown(click);
        }
    }

    public void mouseMoved(Location at) {
        boolean on = this.overBorder(at);
        if (this.onBorder != on) {
            this.markDamaged();
            this.onBorder = on;
        }
        if (!on) {
            at.move(-this.getLeft(), -this.getTop());
            this.wrappedView.mouseMoved(at);
        }
    }

    public void mouseUp(Click click) {
        if (this.overContent(click.getLocation())) {
            click.subtract(this.getLeft(), this.getTop());
            this.wrappedView.mouseUp(click);
        }
    }

    public void exited() {
        this.onBorder = false;
        super.exited();
    }

    public View pickupContent(Location location) {
        location.subtract(this.getLeft(), this.getTop());
        return super.pickupContent(location);
    }

    public View pickupView(Location location) {
        if (this.overBorder(location)) {
            return Toolkit.getViewFactory().createDragViewOutline(this.getView());
        }
        location.subtract(this.getLeft(), this.getTop());
        return super.pickupView(location);
    }

    public void secondClick(Click click) {
        if (this.overContent(click.getLocation())) {
            click.subtract(this.getLeft(), this.getTop());
            this.wrappedView.secondClick(click);
        }
    }

    public void setMaximumSize(Size size) {
        Size wrappedSize = new Size(size);
        wrappedSize.contract(this.getLeft() + this.getRight(), this.getTop() + this.getBottom());
        this.wrappedView.setMaximumSize(wrappedSize);
    }

    public void setSize(Size size) {
        Size wrappedViewSize = new Size(size);
        wrappedViewSize.contract(this.getLeft() + this.getRight(), this.getTop() + this.getBottom());
        this.wrappedView.setSize(wrappedViewSize);
    }

    public void setBounds(Bounds bounds) {
        Bounds wrappedViewBounds = new Bounds(bounds);
        wrappedViewBounds.contract(this.getLeft() + this.getRight(), this.getTop() + this.getBottom());
        this.wrappedView.setBounds(wrappedViewBounds);
    }

    public void thirdClick(Click click) {
        if (this.overContent(click.getLocation())) {
            click.subtract(this.getLeft(), this.getTop());
            this.wrappedView.thirdClick(click);
        }
    }

    public ViewAreaType viewAreaType(Location mouseLocation) {
        Size size = this.wrappedView.getSize();
        Bounds bounds = new Bounds(this.getLeft(), this.getTop(), size.getWidth(), size.getHeight());
        if (bounds.contains(mouseLocation)) {
            mouseLocation.subtract(this.getLeft(), this.getTop());
            return this.wrappedView.viewAreaType(mouseLocation);
        }
        return ViewAreaType.VIEW;
    }
}

