/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.border;

import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewDrag;
import org.nakedobjects.nos.client.dnd.ViewState;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.WindowControl;
import org.nakedobjects.nos.client.dnd.border.AbstractBorder;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.DrawingUtil;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Offset;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.drawing.Text;

public abstract class AbstractWindowBorder
extends AbstractBorder {
    protected static final int LINE_THICKNESS = 5;
    private static final Text TITLE_STYLE = Toolkit.getText("small-title");
    private final int baseline;
    private final int titlebarHeight = Math.max(13 + VPADDING + TITLE_STYLE.getDescent(), TITLE_STYLE.getTextHeight());
    protected WindowControl[] controls;

    public AbstractWindowBorder(View enclosedView) {
        super(enclosedView);
        this.baseline = 18;
        this.left = 5;
        this.right = 5;
        this.top = 5 + this.titlebarHeight;
        this.bottom = 5;
    }

    public void debugDetails(DebugString debug) {
        debug.append((Object)("WindowBorder " + this.left + " pixels\n"));
        debug.append((Object)("           titlebar " + (this.top - this.titlebarHeight) + " pixels"));
        super.debugDetails(debug);
    }

    public Drag dragStart(DragStart drag) {
        if (this.overBorder(drag.getLocation())) {
            Location location = drag.getLocation();
            View dragOverlay = Toolkit.getViewFactory().createDragViewOutline(this.getView());
            return new ViewDrag(this, new Offset(location.getX(), location.getY()), dragOverlay);
        }
        return super.dragStart(drag);
    }

    protected void setControls(WindowControl[] controls) {
        this.controls = controls;
    }

    public void setSize(Size size) {
        super.setSize(size);
        this.layoutControls(size.getWidth());
    }

    public void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        this.layoutControls(bounds.getWidth());
    }

    private void layoutControls(int width) {
        int x = width - this.getPadding().getRight() - (15 + HPADDING) * this.controls.length;
        int y = 5 + VPADDING;
        for (int i = 0; i < this.controls.length; ++i) {
            this.controls[i].setSize(this.controls[i].getRequiredSize(new Size()));
            this.controls[i].setLocation(new Location(x, y));
            x += this.controls[i].getSize().getWidth() + HPADDING;
        }
    }

    public void draw(Canvas canvas) {
        Size s = this.getSize();
        int x = this.left;
        int width = s.getWidth();
        int height = s.getHeight();
        Bounds bounds = this.getBounds();
        canvas.drawSolidRectangle(3, 3, bounds.getWidth() - 6, bounds.getHeight() - 6, Toolkit.getColor("background.window." + this.getSpecification().getName()));
        boolean hasFocus = this.containsFocus();
        Color titleBarBackgroundColor = hasFocus ? Toolkit.getColor("primary3") : Toolkit.getColor("secondary3");
        Color titleBarTextColor = hasFocus ? Toolkit.getColor("black") : Toolkit.getColor("secondary1");
        Color borderColor = hasFocus ? Toolkit.getColor("primary1") : Toolkit.getColor("secondary1");
        Color insetColorLight = hasFocus ? Toolkit.getColor("primary2") : Toolkit.getColor("secondary2");
        Color insetColorDark = hasFocus ? Toolkit.getColor("black") : Toolkit.getColor("black");
        canvas.drawRectangle(1, 0, width - 2, height, borderColor);
        canvas.drawRectangle(0, 1, width, height - 2, borderColor);
        for (int i = 2; i < this.left; ++i) {
            canvas.drawRectangle(i, i, width - 2 * i, height - 2 * i, borderColor);
        }
        ViewState state = this.getState();
        if (state.isActive()) {
            int i = this.left;
            canvas.drawRectangle(i, this.top, width - 2 * i, height - 2 * i - this.top, Toolkit.getColor("active"));
        }
        canvas.drawLine(2, 15, 2, height - 15, insetColorDark);
        canvas.drawLine(3, 16, 3, height - 14, insetColorLight);
        canvas.drawLine(width - 3, 15, width - 3, height - 15, insetColorDark);
        canvas.drawLine(width - 2, 16, width - 2, height - 14, insetColorLight);
        canvas.drawLine(15, 2, width - 15, 2, insetColorDark);
        canvas.drawLine(16, 3, width - 14, 3, insetColorLight);
        canvas.drawLine(15, height - 3, width - 15, height - 3, insetColorDark);
        canvas.drawLine(16, height - 2, width - 14, height - 2, insetColorLight);
        canvas.drawSolidRectangle(this.left, 5, width - this.left - this.right, this.titlebarHeight, titleBarBackgroundColor);
        int y = 5 + this.titlebarHeight - 1;
        canvas.drawLine(x, y, width - this.right - 1, y, borderColor);
        canvas.drawText(this.title(), x + HPADDING, this.baseline, titleBarTextColor, TITLE_STYLE);
        Color white = Toolkit.getColor("white");
        int hatchX = HPADDING + TITLE_STYLE.stringWidth(this.title()) + 10;
        int hatchWidth = this.controls[0].getBounds().getX() - hatchX - 10;
        int hatchY = 7;
        int hatchHeight = this.titlebarHeight - 6;
        DrawingUtil.drawHatching(canvas, hatchX, hatchY, hatchWidth, hatchHeight, borderColor, white);
        for (int i = 0; this.controls != null && i < this.controls.length; ++i) {
            Canvas controlCanvas = canvas.createSubcanvas(this.controls[i].getBounds());
            this.controls[i].draw(controlCanvas);
        }
        super.draw(canvas);
    }

    protected abstract String title();

    public Size getRequiredSize(Size maximumSize) {
        Size size = super.getRequiredSize(maximumSize);
        int width = this.getLeft() + HPADDING + TITLE_STYLE.stringWidth(this.title()) + HPADDING + this.controls.length * (15 + HPADDING) + HPADDING + this.getRight();
        size.ensureWidth(width);
        return size;
    }

    public void secondClick(Click click) {
        View button = this.overControl(click.getLocation());
        if (button == null) {
            super.secondClick(click);
        }
    }

    public void thirdClick(Click click) {
        View button = this.overControl(click.getLocation());
        if (button == null) {
            super.thirdClick(click);
        }
    }

    public void firstClick(Click click) {
        View button = this.overControl(click.getLocation());
        if (button == null) {
            if (this.overBorder(click.getLocation())) {
                Workspace workspace = this.getWorkspace();
                if (workspace != null) {
                    if (click.button2()) {
                        workspace.lower(this.getView());
                    } else if (click.button1()) {
                        workspace.raise(this.getView());
                    }
                }
            } else {
                super.firstClick(click);
            }
        } else {
            button.firstClick(click);
        }
    }

    private View overControl(Location location) {
        for (int i = 0; i < this.controls.length; ++i) {
            WindowControl control = this.controls[i];
            if (!control.getBounds().contains(location)) continue;
            return control;
        }
        return null;
    }
}

