/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.border;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ContentDrag;
import org.nakedobjects.nos.client.dnd.FieldContent;
import org.nakedobjects.nos.client.dnd.InternalDrag;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.ParameterContent;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.ViewState;
import org.nakedobjects.nos.client.dnd.border.LabelBorder;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Text;

public class DroppableLabelBorder
extends LabelBorder {
    private ViewState labelState = new ViewState();
    private boolean overContent;

    public static View createObjectFieldLabelBorder(View view) {
        FieldContent fieldContent = (FieldContent)view.getContent();
        return DroppableLabelBorder.createDroppableLabelBorder(fieldContent.getFieldName(), fieldContent.isMandatory(), view);
    }

    public static View createDroppableLabelBorder(String name, boolean mandatory, View view) {
        Text style = mandatory ? Toolkit.getText("mandatory-label") : Toolkit.getText("label");
        return new DroppableLabelBorder(name, style, view);
    }

    public static View createObjectParameterLabelBorder(View wrappedView) {
        ParameterContent parameterContent = (ParameterContent)wrappedView.getContent();
        return DroppableLabelBorder.createDroppableLabelBorder(parameterContent.getParameterName(), parameterContent.isRequired(), wrappedView);
    }

    protected DroppableLabelBorder(String label, Text style, View view) {
        super(label, style, view);
    }

    public ViewAreaType viewAreaType(Location location) {
        if (this.overBorder(location)) {
            return ViewAreaType.CONTENT;
        }
        return super.viewAreaType(location);
    }

    public void dragCancel(InternalDrag drag) {
        super.dragCancel(drag);
        this.labelState.clearViewIdentified();
    }

    public void drag(ContentDrag drag) {
        Location targetLocation = drag.getTargetLocation();
        if (this.overContent(targetLocation) && !this.overContent) {
            this.overContent = true;
            super.dragIn(drag);
            this.dragOutOfLabel();
        } else if (this.overBorder(targetLocation) && this.overContent) {
            this.overContent = false;
            super.dragOut(drag);
            this.dragInToLabel(drag.getSourceContent());
        }
        super.drag(drag);
    }

    public void dragIn(ContentDrag drag) {
        if (this.overContent(drag.getTargetLocation())) {
            super.dragIn(drag);
        } else {
            Content sourceContent = drag.getSourceContent();
            this.dragInToLabel(sourceContent);
            this.markDamaged();
        }
    }

    private void dragInToLabel(Content sourceContent) {
        this.overContent = false;
        Consent canDrop = this.canDrop(sourceContent);
        if (canDrop.isAllowed()) {
            this.labelState.setCanDrop();
        } else {
            this.labelState.setCantDrop();
        }
        if (!canDrop.getReason().equals("")) {
            this.getFeedbackManager().setAction(canDrop.getReason());
        } else {
            this.getFeedbackManager().setAction("Set to " + sourceContent.title());
        }
    }

    public void dragOut(ContentDrag drag) {
        super.dragOut(drag);
        this.dragOutOfLabel();
    }

    private void dragOutOfLabel() {
        this.labelState.clearObjectIdentified();
        this.markDamaged();
    }

    public void drop(ContentDrag drag) {
        if (this.overContent(drag.getTargetLocation())) {
            super.drop(drag);
        } else {
            this.dragOutOfLabel();
            Content sourceContent = drag.getSourceContent();
            if (this.canDrop(sourceContent).isAllowed()) {
                this.drop(sourceContent);
            }
        }
    }

    protected Consent canDrop(Content dropContent) {
        if (dropContent instanceof ObjectContent) {
            NakedObject source = ((ObjectContent)dropContent).getObject();
            ObjectContent content = (ObjectContent)this.getContent();
            return content.canSet(source);
        }
        return Veto.DEFAULT;
    }

    protected void drop(Content dropContent) {
        if (dropContent instanceof ObjectContent) {
            NakedObject object = ((ObjectContent)dropContent).getObject();
            ((ObjectContent)this.getContent()).setObject(object);
            this.getParent().invalidateContent();
        }
    }

    protected Color textColor() {
        Color color = this.labelState.canDrop() ? Toolkit.getColor("valid") : (this.labelState.cantDrop() ? Toolkit.getColor("invalid") : DEFAULT_COLOR);
        return color;
    }
}

