/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.border;

import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.ContentDrag;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.border.AbstractBorder;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.drawing.Text;
import org.nakedobjects.nos.client.dnd.view.graphic.IconGraphic;
import org.nakedobjects.nos.client.dnd.view.text.ObjectTitleText;
import org.nakedobjects.nos.client.dnd.view.text.TitleText;

public class IconBorder
extends AbstractBorder {
    private static final Text TITLE_STYLE = Toolkit.getText("title");
    private int baseline;
    private int titlebarHeight;
    private int padding = 0;
    private IconGraphic icon = new IconGraphic((View)this, TITLE_STYLE);
    private TitleText text = new ObjectTitleText(this, TITLE_STYLE);

    public IconBorder(View wrappedView) {
        super(wrappedView);
        this.top = this.titlebarHeight = this.icon.getSize().getHeight() + 1;
        this.baseline = this.icon.getBaseline() + 1;
    }

    public void debugDetails(DebugString debug) {
        debug.append((Object)("IconBorder " + this.left + " pixels\n"));
        debug.append((Object)("           titlebar " + (this.top - this.titlebarHeight) + " pixels"));
        super.debugDetails(debug);
    }

    public Drag dragStart(DragStart drag) {
        if (this.overBorder(drag.getLocation())) {
            View dragOverlay = Toolkit.getViewFactory().getContentDragSpecification().createView(this.getContent(), null);
            return new ContentDrag(this, drag.getLocation(), dragOverlay);
        }
        return super.dragStart(drag);
    }

    public void draw(Canvas canvas) {
        int x = this.left + HPADDING;
        if (Toolkit.debug) {
            canvas.drawDebugOutline(new Bounds(this.getSize()), this.baseline, Toolkit.getColor("debug.bounds.draw"));
        }
        this.icon.draw(canvas, x, this.baseline);
        x += this.icon.getSize().getWidth();
        this.text.draw(canvas, x += View.HPADDING, this.baseline);
        super.draw(canvas);
    }

    public int getBaseline() {
        return this.wrappedView.getBaseline() + this.baseline + this.titlebarHeight;
    }

    public Size getRequiredSize(Size maximumSize) {
        Size size = super.getRequiredSize(maximumSize);
        size.ensureWidth(this.left + this.icon.getSize().getWidth() + View.HPADDING + this.text.getSize().getWidth() + this.padding + this.right);
        return size;
    }

    public ViewAreaType viewAreaType(Location mouseLocation) {
        Bounds title = new Bounds(new Location(), this.icon.getSize());
        title.extendWidth(this.left);
        title.extendWidth(this.text.getSize().getWidth());
        if (title.contains(mouseLocation)) {
            return ViewAreaType.CONTENT;
        }
        return super.viewAreaType(mouseLocation);
    }

    public String toString() {
        return this.wrappedView.toString() + "/WindowBorder [" + this.getSpecification() + "]";
    }
}

