/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.border;

import org.nakedobjects.nof.core.util.ToString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.LabelAxis;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewState;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.drawing.Text;
import org.nakedobjects.nos.client.dnd.view.simple.AbstractView;

public class Label
extends AbstractView {
    private static final Color DEFAULT_COLOR = Toolkit.getColor("primary1");
    protected final String label;
    private final Text style;
    private int width;
    private int baseline;

    public Label(String label, Text style, View view) {
        this.label = label + ":";
        this.style = style;
        this.baseline = style.getAscent();
        this.setContent(view.getContent());
        this.setViewAxis(view.getViewAxis());
        int width = HPADDING + style.stringWidth(this.label) + HPADDING;
        if (this.getViewAxis() == null) {
            this.width = width;
        } else {
            ((LabelAxis)this.getViewAxis()).accommodateWidth(width);
        }
    }

    public int getBaseline() {
        return this.baseline;
    }

    protected int getLeft() {
        if (this.getViewAxis() == null) {
            return this.width;
        }
        return ((LabelAxis)this.getViewAxis()).getWidth();
    }

    protected void debugDetails(StringBuffer b) {
        b.append("Label '" + this.label + "'");
    }

    public void draw(Canvas canvas) {
        ViewState state = this.getState();
        Color color = state.canDrop() ? Toolkit.getColor("valid") : (state.cantDrop() ? Toolkit.getColor("invalid") : DEFAULT_COLOR);
        canvas.drawText(this.label, HPADDING, this.baseline, color, this.style);
        super.draw(canvas);
    }

    public Size getMaximumSize() {
        return new Size(this.getLeft(), this.style.getLineHeight());
    }

    public String toString() {
        return ToString.name((Object)this);
    }
}

