/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.border;

import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.ToString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.FieldContent;
import org.nakedobjects.nos.client.dnd.LabelAxis;
import org.nakedobjects.nos.client.dnd.ParameterContent;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.border.AbstractBorder;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Text;

public class LabelBorder
extends AbstractBorder {
    protected static final Color DEFAULT_COLOR = Toolkit.getColor("primary1");
    private final String label;
    private final Text style;

    public static View createFieldLabelBorder(View wrappedView) {
        FieldContent fieldContent = (FieldContent)wrappedView.getContent();
        return LabelBorder.createLabelBorder(fieldContent.getFieldName(), fieldContent.isMandatory(), wrappedView);
    }

    public static View createLabelBorder(String name, boolean mandatory, View wrappedView) {
        Text style = mandatory ? Toolkit.getText("mandatory-label") : Toolkit.getText("label");
        return new LabelBorder(name, style, wrappedView);
    }

    public static View createValueParameterLabelBorder(View wrappedView) {
        ParameterContent fieldContent = (ParameterContent)wrappedView.getContent();
        return LabelBorder.createLabelBorder(fieldContent.getParameterName(), fieldContent.isRequired(), wrappedView);
    }

    public LabelBorder(String label, View wrappedView) {
        this(label, Toolkit.getText("label"), wrappedView);
    }

    public LabelBorder(String label, Text style, View wrappedView) {
        super(wrappedView);
        this.label = label + ":";
        this.style = style;
        int width = HPADDING + style.stringWidth(this.label) + HPADDING;
        if (this.getViewAxis() == null) {
            this.left = width;
        } else {
            ((LabelAxis)this.getViewAxis()).accommodateWidth(width);
        }
    }

    protected int getLeft() {
        if (this.getViewAxis() == null) {
            return this.left;
        }
        return ((LabelAxis)this.getViewAxis()).getWidth();
    }

    public void debugDetails(DebugString debug) {
        super.debugDetails(debug);
        debug.appendln("label", (Object)("'" + this.label + "'"));
    }

    public void draw(Canvas canvas) {
        Color color = this.textColor();
        canvas.drawText(this.label, HPADDING, this.wrappedView.getBaseline(), color, this.style);
        super.draw(canvas);
    }

    protected Color textColor() {
        return DEFAULT_COLOR;
    }

    public String toString() {
        return this.wrappedView.toString() + "/" + ToString.name((Object)this);
    }
}

