/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.border;

import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.border.AbstractBorder;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Size;

public class LineBorder
extends AbstractBorder {
    private final Color color;

    public LineBorder(View wrappedView) {
        this(1, wrappedView);
    }

    public LineBorder(int size, View wrappedView) {
        this(size, Toolkit.getColor("black"), wrappedView);
    }

    public LineBorder(Color color, View wrappedView) {
        this(1, color, wrappedView);
    }

    public LineBorder(int size, Color color, View wrappedView) {
        super(wrappedView);
        this.top = size;
        this.left = size;
        this.bottom = size;
        this.right = size;
        this.color = color;
    }

    protected void debugDetails(DebugString debug) {
        debug.append((Object)("LineBorder " + this.top + " pixels\n"));
    }

    public void draw(Canvas canvas) {
        Size s = this.getSize();
        int width = s.getWidth();
        for (int i = 0; i < this.left; ++i) {
            canvas.drawRectangle(i, i, width - 2 * i, s.getHeight() - 2 * i, this.color);
        }
        super.draw(canvas);
    }

    public String toString() {
        return this.wrappedView.toString() + "/LineBorder";
    }
}

