/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.border;

import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewDrag;
import org.nakedobjects.nos.client.dnd.ViewState;
import org.nakedobjects.nos.client.dnd.border.AbstractBorder;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Image;
import org.nakedobjects.nos.client.dnd.drawing.Offset;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.image.ImageFactory;
import org.nakedobjects.nos.client.dnd.view.simple.DragViewOutline;

public class ObjectBorder
extends AbstractBorder {
    private static final int BORDER = 13;

    public ObjectBorder(int size, View wrappedView) {
        super(wrappedView);
        this.top = size;
        this.left = size;
        this.bottom = size;
        this.right = size + 13;
    }

    public ObjectBorder(View wrappedView) {
        this(1, wrappedView);
    }

    protected void debugDetails(DebugString debug) {
        super.debugDetails(debug);
        debug.appendln("border", (Object)(this.top + " pixel(s)"));
    }

    public Drag dragStart(DragStart drag) {
        if (drag.getLocation().getX() > this.getSize().getWidth() - this.right) {
            if (this.getContent().getNaked() == null) {
                return null;
            }
            DragViewOutline dragOverlay = new DragViewOutline(this.getView());
            return new ViewDrag(this, new Offset(drag.getLocation()), dragOverlay);
        }
        return super.dragStart(drag);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        Color color = null;
        ViewState state = this.getState();
        boolean hasFocus = this.getViewManager().hasFocus(this.getView());
        if (state.canDrop()) {
            color = Toolkit.getColor("valid");
        } else if (state.cantDrop()) {
            color = Toolkit.getColor("invalid");
        } else if (hasFocus) {
            color = Toolkit.getColor("identified");
        } else if (state.isObjectIdentified()) {
            color = Toolkit.getColor("secondary2");
        }
        Size s = this.getSize();
        if (this.getContent().isPersistable() && this.getContent().isTransient()) {
            int x = s.getWidth() - 13;
            int y = 0;
            Image icon = ImageFactory.getInstance().loadIcon("transient", 8, null);
            if (icon == null) {
                canvas.drawText("*", x, y + Toolkit.getText("normal").getAscent(), Toolkit.getColor("black"), Toolkit.getText("normal"));
            } else {
                canvas.drawImage(icon, x, y, 12, 12);
            }
        }
        if (color != null) {
            int i;
            int xExtent;
            if (hasFocus) {
                xExtent = s.getWidth() - this.left;
                for (i = 0; i < this.left; ++i) {
                    canvas.drawRectangle(i, i, xExtent - 2 * i, s.getHeight() - 2 * i, color);
                }
            } else {
                xExtent = s.getWidth();
                for (i = 0; i < this.left; ++i) {
                    canvas.drawRectangle(i, i, xExtent - 2 * i, s.getHeight() - 2 * i, color);
                }
                canvas.drawLine(xExtent - 13, this.top, xExtent - 13, this.top + s.getHeight(), color);
                canvas.drawSolidRectangle(xExtent - 13 + 1, this.top, 11, s.getHeight() - 2 * this.top, Toolkit.getColor("secondary3"));
            }
        }
    }

    public void entered() {
        this.getState().setContentIdentified();
        this.getState().setViewIdentified();
        this.wrappedView.entered();
        this.markDamaged();
    }

    public void exited() {
        this.getState().clearObjectIdentified();
        this.getState().clearViewIdentified();
        this.wrappedView.exited();
        this.markDamaged();
    }

    public String toString() {
        return this.wrappedView.toString() + "/ObjectBorder [" + this.getSpecification() + "]";
    }
}

