/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.border;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.persist.NakedObjectPersistor;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nos.client.dnd.ButtonAction;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.FieldContent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractButtonAction;
import org.nakedobjects.nos.client.dnd.border.ButtonBorder;
import org.nakedobjects.nos.client.dnd.border.SaveState;
import org.nakedobjects.nos.client.dnd.content.RootObject;
import org.nakedobjects.nos.client.dnd.drawing.Location;

class SaveTransientObjectBorder
extends ButtonBorder {
    private static final Logger LOG = Logger.getLogger(SaveTransientObjectBorder.class);

    private static Consent canSave(View view) {
        SaveState saveState = new SaveState();
        NakedObject transientObject = (NakedObject)view.getContent().getNaked();
        SaveTransientObjectBorder.checkFields(saveState, view, transientObject);
        String error = saveState.getMessage();
        Consent consent = view.getContent().getSpecification().isPersistable(transientObject);
        if (consent.isVetoed()) {
            if (error.length() > 0) {
                error = error + "; ";
            }
            error = error + consent.getReason();
        }
        if (error.length() == 0) {
            return Allow.DEFAULT;
        }
        return new Veto(error);
    }

    private static void checkFields(SaveState saveState, View view, NakedObject forObject) {
        if (view.getContent().getNaked() != forObject) {
            return;
        }
        View[] subviews = view.getSubviews();
        for (int i = 0; i < subviews.length; ++i) {
            String parameterName;
            boolean isFieldEmpty;
            View fieldView = subviews[i];
            Content content = fieldView.getContent();
            if (content instanceof RootObject) {
                SaveTransientObjectBorder.checkFields(saveState, fieldView, forObject);
                continue;
            }
            if (!(content instanceof FieldContent)) continue;
            boolean isMandatory = ((FieldContent)content).isMandatory();
            Naked field = content.getNaked();
            boolean bl = isFieldEmpty = field == null || field instanceof NakedValue && ((NakedValue)field).isEmpty();
            if (isMandatory && isFieldEmpty) {
                parameterName = ((FieldContent)content).getFieldName();
                saveState.addMissingField(parameterName);
                continue;
            }
            if (!fieldView.getState().isInvalid()) continue;
            parameterName = ((FieldContent)content).getFieldName();
            saveState.addInvalidField(parameterName);
        }
    }

    private static void close(Workspace workspace, View view) {
        view.dispose();
    }

    private static NakedObject save(View view) {
        NakedObject transientObject = (NakedObject)view.getContent().getNaked();
        NakedObjectPersistor persistor = NakedObjectsContext.getObjectPersistor();
        try {
            persistor.startTransaction();
            persistor.makePersistent(transientObject);
            persistor.endTransaction();
        }
        catch (RuntimeException e) {
            LOG.info((Object)("exception saving " + transientObject + ", aborting transaction"), (Throwable)e);
            try {
                persistor.abortTransaction();
            }
            catch (Exception e2) {
                LOG.error((Object)"failure during abort", (Throwable)e2);
            }
            throw e;
        }
        return transientObject;
    }

    public SaveTransientObjectBorder(View view) {
        super(new ButtonAction[]{new SaveAction(), new SaveAndCloseAction(), new CloseAction()}, view);
    }

    private static class SaveAndCloseAction
    extends AbstractButtonAction {
        public SaveAndCloseAction() {
            super("Save & Close");
        }

        public Consent disabled(View view) {
            return SaveTransientObjectBorder.canSave(view);
        }

        public void execute(Workspace workspace, View view, Location at) {
            SaveTransientObjectBorder.save(view);
            SaveTransientObjectBorder.close(workspace, view);
        }
    }

    private static class SaveAction
    extends AbstractButtonAction {
        public SaveAction() {
            super("Save");
        }

        public Consent disabled(View view) {
            return SaveTransientObjectBorder.canSave(view);
        }

        public void execute(Workspace workspace, View view, Location at) {
            SaveTransientObjectBorder.save(view);
            ViewSpecification spec = view.getSpecification();
            View newView = spec.createView(view.getContent(), null);
            workspace.replaceView(view, newView);
        }
    }

    private static class CloseAction
    extends AbstractButtonAction {
        public CloseAction() {
            super("Discard");
        }

        public void execute(Workspace workspace, View view, Location at) {
            SaveTransientObjectBorder.close(workspace, view);
        }
    }
}

