/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.border;

import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.action.CloseWindowControl;
import org.nakedobjects.nos.client.dnd.action.IconizeViewOption;
import org.nakedobjects.nos.client.dnd.action.IconizeWindowControl;
import org.nakedobjects.nos.client.dnd.action.ResizeWindowControl;
import org.nakedobjects.nos.client.dnd.action.WindowControl;
import org.nakedobjects.nos.client.dnd.border.AbstractWindowBorder;
import org.nakedobjects.nos.client.dnd.border.ButtonBorder;
import org.nakedobjects.nos.client.dnd.border.SaveTransientObjectBorder;
import org.nakedobjects.nos.client.dnd.border.ScrollBorder;
import org.nakedobjects.nos.client.dnd.drawing.Image;
import org.nakedobjects.nos.client.dnd.image.ImageFactory;

public class WindowBorder
extends AbstractWindowBorder {
    private static final IconizeViewOption iconizeOption = new IconizeViewOption();

    public WindowBorder(View wrappedView, boolean scrollable) {
        super(WindowBorder.addTransientBorderIfNeccessary(scrollable ? new ScrollBorder(wrappedView) : wrappedView));
        if (this.isTransient()) {
            this.setControls(new WindowControl[]{new CloseWindowControl(this)});
        } else {
            this.setControls(new WindowControl[]{new IconizeWindowControl(this), new ResizeWindowControl(this), new CloseWindowControl(this)});
        }
    }

    private static View addTransientBorderIfNeccessary(View view) {
        Content content = view.getContent();
        if (content.isPersistable() && content.isTransient()) {
            return new SaveTransientObjectBorder(view);
        }
        return view;
    }

    public View[] getButtons() {
        if (this.wrappedView instanceof ButtonBorder) {
            return ((ButtonBorder)this.wrappedView).getButtons();
        }
        return new View[0];
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.isTransient()) {
            int height = this.top - 5 - 2;
            int x = this.getSize().getWidth() - 50;
            Image icon = ImageFactory.getInstance().loadIcon("transient", height, null);
            if (icon == null) {
                canvas.drawText("*", x, this.getBaseline(), Toolkit.getColor("black"), Toolkit.getText("normal"));
            } else {
                canvas.drawImage(icon, x, 6, height, height);
            }
        }
    }

    private boolean isTransient() {
        Content content = this.getContent();
        return content.isPersistable() && content.isTransient();
    }

    public void viewMenuOptions(UserActionSet menuOptions) {
        super.viewMenuOptions(menuOptions);
        menuOptions.add(iconizeOption);
    }

    public void secondClick(Click click) {
        if (this.overBorder(click.getLocation())) {
            iconizeOption.execute(this.getWorkspace(), this.getView(), this.getAbsoluteLocation());
        } else {
            super.secondClick(click);
        }
    }

    protected String title() {
        return this.getContent().windowTitle();
    }

    public String toString() {
        return this.wrappedView.toString() + "/WindowBorder [" + this.getSpecification() + "]";
    }
}

