/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.builder;

import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.OneToManyAssociation;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nos.client.dnd.CollectionContent;
import org.nakedobjects.nos.client.dnd.CompositeViewSpecification;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.OneToManyField;
import org.nakedobjects.nos.client.dnd.SubviewSpec;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.builder.AbstractViewBuilder;
import org.nakedobjects.nos.client.dnd.content.AbstractObjectContent;
import org.nakedobjects.nos.client.dnd.content.CollectionElement;
import org.nakedobjects.nos.client.dnd.content.OneToManyFieldElementImpl;
import org.nakedobjects.nos.client.dnd.view.simple.CompositeView;

public class CollectionElementBuilder
extends AbstractViewBuilder {
    private static final Logger LOG = Logger.getLogger(CollectionElementBuilder.class);
    private boolean canDragView = true;
    private SubviewSpec subviewDesign;

    public CollectionElementBuilder(SubviewSpec subviewDesign) {
        this.subviewDesign = subviewDesign;
    }

    public void build(View view) {
        Assert.assertEquals((Object)view.getView(), (Object)view);
        Content content = view.getContent();
        OneToManyAssociation field = content instanceof OneToManyField ? ((OneToManyField)content).getOneToManyAssociation() : null;
        LOG.debug((Object)("rebuild view " + view + " for " + content));
        CollectionContent collectionContent = (CollectionContent)((Object)content);
        Enumeration elements = collectionContent.allElements();
        View[] subviews = view.getSubviews();
        NakedObject[] existingElements = new NakedObject[subviews.length];
        for (int i = 0; i < subviews.length; ++i) {
            view.removeView(subviews[i]);
            existingElements[i] = subviews[i].getContent().getNaked();
        }
        while (elements.hasMoreElements()) {
            NakedObject element = (NakedObject)elements.nextElement();
            View elementView = null;
            for (int i = 0; i < subviews.length; ++i) {
                if (existingElements[i] != element) continue;
                elementView = subviews[i];
                existingElements[i] = null;
                break;
            }
            if (elementView == null) {
                AbstractObjectContent elementContent;
                if (field == null) {
                    elementContent = new CollectionElement(element);
                } else {
                    NakedObject obj;
                    NakedObject parent = obj = ((OneToManyField)view.getContent()).getParent();
                    elementContent = new OneToManyFieldElementImpl(parent, element, field);
                }
                elementView = this.subviewDesign.createSubview(elementContent, view.getViewAxis());
            }
            if (elementView == null) continue;
            view.addView(elementView);
        }
    }

    public View createCompositeView(Content content, CompositeViewSpecification specification, ViewAxis axis) {
        CompositeView view = new CompositeView(content, specification, axis);
        view.setCanDragView(this.canDragView);
        return view;
    }

    public void setCanDragView(boolean canDragView) {
        this.canDragView = canDragView;
    }
}

