/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.builder;

import org.nakedobjects.nos.client.dnd.CompositeViewBuilder;
import org.nakedobjects.nos.client.dnd.LabelAxis;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.builder.AbstractBuilderDecorator;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;

public class LabelledFieldLayout
extends AbstractBuilderDecorator {
    public LabelledFieldLayout(CompositeViewBuilder design) {
        super(design);
    }

    public Size getRequiredSize(View view) {
        int height = 0;
        int width = 0;
        View[] views = view.getSubviews();
        for (int i = 0; i < views.length; ++i) {
            View v = views[i];
            Size s = v.getRequiredSize(new Size());
            height = Math.max(height, s.getHeight());
            width += s.getWidth();
        }
        return new Size(width += View.HPADDING, height);
    }

    public boolean isOpen() {
        return false;
    }

    public void layout(View view, Size maximumSize) {
        int x = 0;
        int y = 0;
        View[] subviews = view.getSubviews();
        for (int i = 0; i < subviews.length; ++i) {
            View v = subviews[i];
            v.layout(maximumSize);
            Size s = v.getRequiredSize(new Size());
            v.setSize(s);
            v.setLocation(new Location(x, y));
            x = ((LabelAxis)v.getViewAxis()).getWidth() + View.HPADDING;
        }
    }
}

