/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.builder;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nof.core.util.UnknownTypeException;
import org.nakedobjects.nos.client.dnd.CompositeViewSpecification;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.FieldContent;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.SubviewSpec;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.builder.AbstractViewBuilder;
import org.nakedobjects.nos.client.dnd.view.simple.CompositeView;
import org.nakedobjects.nos.client.dnd.view.simple.FieldErrorView;

public class ObjectFieldBuilder
extends AbstractViewBuilder {
    private static final Logger LOG = Logger.getLogger(ObjectFieldBuilder.class);
    private SubviewSpec subviewDesign;
    private final boolean useFieldType;

    public ObjectFieldBuilder(SubviewSpec subviewDesign) {
        this(subviewDesign, false);
    }

    public ObjectFieldBuilder(SubviewSpec subviewDesign, boolean useFieldType) {
        this.subviewDesign = subviewDesign;
        this.useFieldType = useFieldType;
    }

    public void build(View view) {
        Assert.assertEquals((String)"ensure the view is the complete decorated view", (Object)view.getView(), (Object)view);
        Content content = view.getContent();
        NakedObject object = ((ObjectContent)content).getObject();
        LOG.debug((Object)("build view " + view + " for " + object));
        NakedObjectSpecification spec = null;
        if (this.useFieldType) {
            spec = content.getSpecification();
        }
        if (spec == null) {
            spec = object.getSpecification();
        }
        NakedObjectField[] flds = spec.getDynamicallyVisibleFields(object);
        if (view.getSubviews().length == 0) {
            this.newBuild(view, object, flds);
        } else {
            this.updateBuild(view, object, flds);
        }
    }

    public View createCompositeView(Content content, CompositeViewSpecification specification, ViewAxis axis) {
        return new CompositeView(content, specification, axis);
    }

    public View decorateSubview(View subview) {
        return this.subviewDesign.decorateSubview(subview);
    }

    private void newBuild(View view, NakedObject object, NakedObjectField[] flds) {
        LOG.debug((Object)"  as new build");
        for (int f = 0; f < flds.length; ++f) {
            NakedObjectField field = flds[f];
            this.addField(view, object, field);
        }
    }

    private void addField(View view, NakedObject object, NakedObjectField field) {
        Naked value = field.get(object);
        View fieldView = this.createFieldView(view, object, field, value);
        if (fieldView != null) {
            view.addView(this.decorateSubview(fieldView));
        }
    }

    private void updateBuild(View view, NakedObject object, NakedObjectField[] flds) {
        int i;
        LOG.debug((Object)"  as update build");
        View[] subviews = view.getSubviews();
        block0: for (i = 0; i < subviews.length; ++i) {
            FieldContent fieldContent = (FieldContent)subviews[i].getContent();
            for (int j = 0; j < flds.length; ++j) {
                NakedObjectField field = flds[j];
                if (fieldContent.getField() == field) continue block0;
            }
            view.removeView(subviews[i]);
        }
        subviews = view.getSubviews();
        for (i = 0; i < subviews.length; ++i) {
            View subview = subviews[i];
            NakedObjectField field = ((FieldContent)subview.getContent()).getField();
            Naked value = field.get(object);
            if (field.isValue()) {
                Naked naked = subview.getContent().getNaked();
                if (value != null && value.getObject() != null && !value.getObject().equals(naked.getObject())) {
                    View fieldView = this.createFieldView(view, object, field, value);
                    view.replaceView(subview, this.decorateSubview(fieldView));
                    continue;
                }
                subview.refresh();
                continue;
            }
            if (field.isCollection()) {
                subview.update(value);
                continue;
            }
            if (field.isObject()) {
                boolean isDestroyed;
                NakedObject existing = ((ObjectContent)subviews[i].getContent()).getObject();
                boolean changedValue = value != existing;
                boolean bl = isDestroyed = existing != null && existing.getResolveState().isDestroyed();
                if (!changedValue && !isDestroyed) continue;
                View fieldView = this.createFieldView(view, object, field, value);
                if (fieldView != null) {
                    view.replaceView(subview, this.decorateSubview(fieldView));
                    continue;
                }
                view.addView(new FieldErrorView("No field for " + value));
                continue;
            }
            throw new UnknownTypeException(field.getName());
        }
        block3: for (int j = 0; j < flds.length; ++j) {
            NakedObjectField field = flds[j];
            for (int i2 = 0; i2 < subviews.length; ++i2) {
                FieldContent fieldContent = (FieldContent)subviews[i2].getContent();
                if (fieldContent.getField() == field) continue block3;
            }
            this.addField(view, object, field);
        }
    }

    private View createFieldView(View view, NakedObject object, NakedObjectField field, Naked value) {
        if (field == null) {
            throw new NullPointerException();
        }
        if (field.isObject()) {
            NakedObjectsContext.getObjectPersistor().resolveField(object, field);
        }
        Content content1 = Toolkit.getContentFactory().createFieldContent(field, object, value);
        View fieldView = this.subviewDesign.createSubview(content1, view.getViewAxis());
        return fieldView;
    }
}

