/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.builder;

import org.nakedobjects.nos.client.dnd.CompositeViewBuilder;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.builder.AbstractBuilderDecorator;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;

public class StackLayout
extends AbstractBuilderDecorator {
    private boolean fixedWidth;

    public StackLayout(CompositeViewBuilder design) {
        super(design);
        this.fixedWidth = false;
    }

    public StackLayout(CompositeViewBuilder design, boolean fixedWidth) {
        super(design);
        this.fixedWidth = fixedWidth;
    }

    public Size getRequiredSize(View view) {
        int height = 0;
        int width = 0;
        View[] views = view.getSubviews();
        for (int i = 0; i < views.length; ++i) {
            View v = views[i];
            Size s = v.getRequiredSize(new Size());
            width = Math.max(width, s.getWidth());
            height += s.getHeight();
        }
        return new Size(width, height);
    }

    public boolean isOpen() {
        return true;
    }

    public void layout(View view, Size maximumSize) {
        Size s;
        View v;
        int i;
        int x = 0;
        int y = 0;
        View[] subviews = view.getSubviews();
        int maxWidth = 0;
        for (i = 0; i < subviews.length; ++i) {
            v = subviews[i];
            v.layout(new Size(maximumSize));
            s = v.getRequiredSize(new Size(maximumSize));
            maxWidth = Math.max(maxWidth, s.getWidth());
        }
        for (i = 0; i < subviews.length; ++i) {
            v = subviews[i];
            s = v.getRequiredSize(new Size());
            if (this.fixedWidth || v.getSpecification().isAligned()) {
                s.ensureWidth(maxWidth);
            }
            v.setSize(s);
            v.setLocation(new Location(x, y));
            y += s.getHeight();
        }
    }
}

