/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.content;

import java.util.Enumeration;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.reflect.AbstractConsent;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.UnexpectedCallException;
import org.nakedobjects.nos.client.dnd.CollectionContent;
import org.nakedobjects.nos.client.dnd.CollectionSorter;
import org.nakedobjects.nos.client.dnd.Comparator;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.content.AbstractContent;
import org.nakedobjects.nos.client.dnd.content.FieldComparator;
import org.nakedobjects.nos.client.dnd.content.OptionFactory;
import org.nakedobjects.nos.client.dnd.content.SimpleCollectionSorter;
import org.nakedobjects.nos.client.dnd.content.TitleComparator;
import org.nakedobjects.nos.client.dnd.content.TypeComparator;
import org.nakedobjects.nos.client.dnd.drawing.Image;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.image.ImageFactory;

public abstract class AbstractCollectionContent
extends AbstractContent
implements CollectionContent {
    private static final TypeComparator TYPE_COMPARATOR = new TypeComparator();
    private static final TitleComparator TITLE_COMPARATOR = new TitleComparator();
    private static final CollectionSorter sorter = new SimpleCollectionSorter();
    private Comparator order;
    private boolean reverse;

    public final Enumeration allElements() {
        final NakedObject[] elements = this.elements();
        sorter.sort(elements, this.order, this.reverse);
        return new Enumeration(){
            int i = 0;
            int size = elements.length;

            public boolean hasMoreElements() {
                return this.i < this.size;
            }

            public Object nextElement() {
                return elements[this.i++];
            }
        };
    }

    public void debugDetails(DebugString debug) {
        debug.appendln("order", (Object)this.order);
        debug.appendln("reverse order", this.reverse);
    }

    public NakedObject[] elements() {
        NakedCollection collection = this.getCollection();
        if (collection == null) {
            return new NakedObject[0];
        }
        NakedObject[] elementsArray = new NakedObject[collection.size()];
        int i = 0;
        Enumeration elements = collection.elements();
        while (elements.hasMoreElements()) {
            elementsArray[i++] = (NakedObject)elements.nextElement();
        }
        return elementsArray;
    }

    public abstract NakedCollection getCollection();

    public String getDescription() {
        return "Collection";
    }

    public void contentMenuOptions(UserActionSet options) {
        final NakedCollection collection = this.getCollection();
        OptionFactory.addObjectMenuOptions((NakedReference)collection, options);
        options.add(new AbstractUserAction("Clear resolved", UserAction.DEBUG){

            public Consent disabled(View component) {
                return AbstractConsent.allow((collection == null || collection.getResolveState() != ResolveState.TRANSIENT || collection.getResolveState() == ResolveState.GHOST ? 1 : 0) != 0);
            }

            public void execute(Workspace workspace, View view, Location at) {
                collection.changeState(ResolveState.GHOST);
            }
        });
    }

    public void viewMenuOptions(UserActionSet options) {
        UserActionSet sortOptions = new UserActionSet("Sort", options);
        options.add(sortOptions);
        sortOptions.add(new AbstractUserAction("Clear"){

            public Consent disabled(View component) {
                return AbstractConsent.allow((AbstractCollectionContent.this.order != null ? 1 : 0) != 0);
            }

            public void execute(Workspace workspace, View view, Location at) {
                AbstractCollectionContent.this.order = null;
                view.invalidateContent();
            }
        });
        if (this.reverse) {
            sortOptions.add(new AbstractUserAction("Normal sort order"){

                public Consent disabled(View component) {
                    return AbstractConsent.allow((AbstractCollectionContent.this.order != null ? 1 : 0) != 0);
                }

                public void execute(Workspace workspace, View view, Location at) {
                    AbstractCollectionContent.this.reverse = false;
                    view.invalidateContent();
                }
            });
        } else {
            sortOptions.add(new AbstractUserAction("Reverse sort order"){

                public Consent disabled(View component) {
                    return AbstractConsent.allow((AbstractCollectionContent.this.order != null ? 1 : 0) != 0);
                }

                public void execute(Workspace workspace, View view, Location at) {
                    AbstractCollectionContent.this.reverse = true;
                    view.invalidateContent();
                }
            });
        }
        sortOptions.add(new AbstractUserAction("Sort by title"){

            public Consent disabled(View component) {
                return AbstractConsent.allow((AbstractCollectionContent.this.order != TITLE_COMPARATOR ? 1 : 0) != 0);
            }

            public void execute(Workspace workspace, View view, Location at) {
                AbstractCollectionContent.this.order = TITLE_COMPARATOR;
                view.invalidateContent();
            }
        });
        sortOptions.add(new AbstractUserAction("Sort by type"){

            public Consent disabled(View component) {
                return AbstractConsent.allow((AbstractCollectionContent.this.order != TYPE_COMPARATOR ? 1 : 0) != 0);
            }

            public void execute(Workspace workspace, View view, Location at) {
                AbstractCollectionContent.this.order = TYPE_COMPARATOR;
                view.invalidateContent();
            }
        });
        NakedCollection c = this.getCollection();
        if (c instanceof NakedCollection) {
            NakedObjectSpecification spec = c.getElementSpecification();
            NakedObjectField[] fields = spec.getFields();
            for (int i = 0; i < fields.length; ++i) {
                final NakedObjectField field = fields[i];
                sortOptions.add(new AbstractUserAction("Sort by " + field.getName()){

                    public void execute(Workspace workspace, View view, Location at) {
                        AbstractCollectionContent.this.order = new FieldComparator(field);
                        view.invalidateContent();
                    }
                });
            }
        }
    }

    public void parseTextEntry(String entryText) {
        throw new UnexpectedCallException();
    }

    public void setOrder(Comparator order) {
        this.order = order;
    }

    public void setOrderByField(NakedObjectField field) {
        if (this.order instanceof FieldComparator && ((FieldComparator)this.order).getField() == field) {
            this.reverse = !this.reverse;
        } else {
            this.order = new FieldComparator(field);
            this.reverse = false;
        }
    }

    public void setOrderByElement() {
        if (this.order == TITLE_COMPARATOR) {
            this.reverse = !this.reverse;
        } else {
            this.order = TITLE_COMPARATOR;
            this.reverse = false;
        }
    }

    public NakedObjectField getFieldSortOrder() {
        if (this.order instanceof FieldComparator) {
            return ((FieldComparator)this.order).getField();
        }
        return null;
    }

    public Image getIconPicture(int iconHeight) {
        NakedCollection nakedObject = this.getCollection();
        if (nakedObject == null) {
            return ImageFactory.getInstance().loadIcon("emptyField", iconHeight, null);
        }
        NakedObjectSpecification specification = nakedObject.getSpecification();
        Image icon = ImageFactory.getInstance().loadIcon(specification, iconHeight, null);
        if (icon == null) {
            icon = ImageFactory.getInstance().loadDefaultIcon(iconHeight, null);
        }
        return icon;
    }

    public boolean getOrderByElement() {
        return this.order == TITLE_COMPARATOR;
    }

    public boolean getReverseSortOrder() {
        return this.reverse;
    }

    public boolean isOptionEnabled() {
        return false;
    }

    public Naked[] getOptions() {
        return null;
    }
}

