/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.adapter.Persistable;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.OneToOneAssociation;
import org.nakedobjects.noa.reflect.ValueAssociation;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.persist.AllInstances;
import org.nakedobjects.nof.core.reflect.AbstractConsent;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nof.core.util.UnexpectedCallException;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.content.AbstractContent;
import org.nakedobjects.nos.client.dnd.content.OptionFactory;
import org.nakedobjects.nos.client.dnd.drawing.Image;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.image.ImageFactory;

public abstract class AbstractObjectContent
extends AbstractContent
implements ObjectContent {
    public abstract Consent canClear();

    public Consent canDrop(Content sourceContent) {
        NakedObject target = this.getObject();
        if (!(sourceContent instanceof ObjectContent) || target == null) {
            return new Veto("Can't drop " + sourceContent.getNaked().titleString() + " on to empty target");
        }
        NakedObject source = ((ObjectContent)sourceContent).getObject();
        return this.canDropOntoObject(target, source);
    }

    private Consent canDropOntoObject(NakedObject target, NakedObject source) {
        NakedObjectAction action = this.dropAction(source, target);
        if (action != null) {
            Consent parameterSetValid = action.isParameterSetValid((NakedReference)target, (Naked[])new NakedObject[]{source});
            if (parameterSetValid.isAllowed()) {
                parameterSetValid = new Allow("Execute '" + action.getName() + "' with " + source.titleString());
            }
            return parameterSetValid;
        }
        return this.setFieldOfMatchingType(target, source);
    }

    private Consent setFieldOfMatchingType(NakedObject target, NakedObject source) {
        if (target.getResolveState().isTransient() && source.getResolveState().isPersistent()) {
            return new Veto("Can't set field in persistent object with reference to non-persistent object");
        }
        NakedObjectField[] fields = target.getSpecification().getDynamicallyVisibleFields(target);
        for (int i = 0; i < fields.length; ++i) {
            NakedObjectField fld = fields[i];
            if (!fld.isObject() || !source.getSpecification().isOfType(fld.getSpecification()) || fld.get(target) != null || !((OneToOneAssociation)fld).isAssociationValid(target, source).isAllowed()) continue;
            return new Allow("Set field " + fld.getName());
        }
        return new Veto("No empty field accepting object of type " + source.getSpecification().getSingularName() + " in " + this.title());
    }

    public abstract Consent canSet(NakedObject var1);

    public abstract void clear();

    public Naked drop(Content sourceContent) {
        if (sourceContent instanceof ObjectContent) {
            NakedObject source = (NakedObject)sourceContent.getNaked();
            Assert.assertNotNull((Object)source);
            NakedObject target = this.getObject();
            Assert.assertNotNull((Object)target);
            if (this.canDrop(sourceContent).isAllowed()) {
                NakedObjectAction action = this.dropAction(source, target);
                if (action != null && action.isParameterSetValid((NakedReference)target, (Naked[])new NakedObject[]{source}).isAllowed()) {
                    return action.execute((NakedReference)target, (Naked[])new NakedObject[]{source});
                }
                NakedObjectField[] fields = target.getSpecification().getDynamicallyVisibleFields(target);
                for (int i = 0; i < fields.length; ++i) {
                    NakedObjectField fld = fields[i];
                    if (!fld.isObject() || !source.getSpecification().isOfType(fld.getSpecification()) || fld.get(target) != null || !((OneToOneAssociation)fld).isAssociationValid(target, source).isAllowed()) continue;
                    ((OneToOneAssociation)fld).setAssociation(target, source);
                    break;
                }
            }
        }
        return null;
    }

    private NakedObjectAction dropAction(NakedObject source, NakedObject target) {
        NakedObjectAction action = target.getSpecification().getObjectAction(NakedObjectAction.USER, null, new NakedObjectSpecification[]{source.getSpecification()});
        return action;
    }

    public abstract NakedObject getObject();

    public boolean isPersistable() {
        return this.getObject().persistable() == Persistable.USER_PERSISTABLE;
    }

    public void contentMenuOptions(UserActionSet options) {
        NakedObject object = this.getObject();
        OptionFactory.addObjectMenuOptions((NakedReference)object, options);
        if (this.getObject() == null) {
            OptionFactory.addCreateOptions(this.getSpecification(), options);
        } else {
            options.add(new ExplorationInstances());
        }
        options.add(new ExplorationClone());
        options.add(new DebugClearResolvedOption());
    }

    public void parseTextEntry(String entryText) {
        throw new UnexpectedCallException();
    }

    public abstract void setObject(NakedObject var1);

    public String getIconName() {
        NakedObject object = this.getObject();
        return object == null ? null : object.getIconName();
    }

    public Image getIconPicture(int iconHeight) {
        NakedObject nakedObject = this.getObject();
        if (nakedObject == null) {
            return ImageFactory.getInstance().loadIcon("empty-field", iconHeight, null);
        }
        NakedObjectSpecification specification = nakedObject.getSpecification();
        Image icon = ImageFactory.getInstance().loadIcon(specification, iconHeight, null);
        return icon;
    }

    public static final class DebugClearResolvedOption
    extends AbstractUserAction {
        private DebugClearResolvedOption() {
            super("Clear resolved", UserAction.DEBUG);
        }

        public Consent disabled(View view) {
            NakedObject object = (NakedObject)view.getContent().getNaked();
            return AbstractConsent.allow((object == null || object.getResolveState() != ResolveState.TRANSIENT || object.getResolveState() == ResolveState.GHOST ? 1 : 0) != 0);
        }

        public void execute(Workspace workspace, View view, Location at) {
            NakedObject object = (NakedObject)view.getContent().getNaked();
            object.changeState(ResolveState.GHOST);
        }
    }

    public static final class ExplorationClone
    extends AbstractUserAction {
        public ExplorationClone() {
            super("Clone", UserAction.EXPLORATION);
        }

        public Consent disabled(View view) {
            NakedObject object = (NakedObject)view.getContent().getNaked();
            return AbstractConsent.allow((object != null ? 1 : 0) != 0);
        }

        public void execute(Workspace workspace, View view, Location at) {
            NakedObject original = (NakedObject)view.getContent().getNaked();
            NakedObjectSpecification spec = original.getSpecification();
            NakedObject clone = NakedObjectsContext.getObjectLoader().createTransientInstance(spec);
            NakedObjectField[] fields = spec.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Naked fld = fields[i].get(original);
                if (fields[i].isObject()) {
                    ((OneToOneAssociation)fields[i]).setAssociation(clone, (NakedObject)fld);
                    continue;
                }
                if (fields[i].isValue()) {
                    ((ValueAssociation)fields[i]).setValue(clone, (NakedValue)fld);
                    continue;
                }
                if (!fields[i].isCollection()) continue;
            }
            Content content = Toolkit.getContentFactory().createRootContent((Naked)clone);
            View cloneView = Toolkit.getViewFactory().createWindow(content);
            cloneView.setLocation(at);
            workspace.addView(cloneView);
        }
    }

    public static final class ExplorationInstances
    extends AbstractUserAction {
        public ExplorationInstances() {
            super("Instances", UserAction.EXPLORATION);
        }

        public Consent disabled(View view) {
            Naked object = view.getContent().getNaked();
            return AbstractConsent.allow((object != null ? 1 : 0) != 0);
        }

        public void execute(Workspace workspace, View view, Location at) {
            Naked object = view.getContent().getNaked();
            NakedObjectSpecification spec = object.getSpecification();
            NakedCollection instances = NakedObjectsContext.getObjectPersistor().findInstances((InstancesCriteria)new AllInstances(spec, false));
            Content content = Toolkit.getContentFactory().createRootContent((Naked)instances);
            View cloneView = Toolkit.getViewFactory().createWindow(content);
            cloneView.setLocation(at);
            workspace.addView(cloneView);
        }
    }
}

