/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.util.ToString;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;

public abstract class AbstractObjectOption
extends AbstractUserAction {
    protected final NakedObjectAction action;
    protected final NakedReference target;

    protected AbstractObjectOption(NakedObjectAction action, NakedReference target, String name) {
        super(name);
        this.action = action;
        this.target = target;
    }

    public Consent disabled(View view) {
        NakedObject adapter = (NakedObject)view.getContent().getNaked();
        if (adapter.getResolveState().isDestroyed()) {
            return new Veto("Can't do anything with a destroyed object");
        }
        Consent usableForUser = this.action.isUsable();
        if (usableForUser.isVetoed()) {
            return usableForUser;
        }
        Consent usableInState = this.action.isUsable(this.target);
        if (usableInState.isVetoed()) {
            return usableInState;
        }
        Consent validParameters = this.checkValid();
        if (validParameters != null && validParameters.isVetoed()) {
            return validParameters;
        }
        String desc = this.action.getDescription();
        String description = this.getName(view) + (desc.length() == 0 ? "" : ": " + desc);
        return new Allow(description);
    }

    protected Consent checkValid() {
        return null;
    }

    public String getHelp(View view) {
        return this.action.getHelp();
    }

    public NakedObjectAction.Type getType() {
        return this.action.getType();
    }

    public String toString() {
        return new ToString((Object)this).append("action", (Object)this.action).toString();
    }
}

