/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nos.client.dnd.ParameterContent;
import org.nakedobjects.nos.client.dnd.content.ObjectParameterImpl;
import org.nakedobjects.nos.client.dnd.content.ValueParameterImpl;

public class ActionHelper {
    private final NakedObjectAction action;
    private final String[] names;
    private final Naked[] parameters;
    private final NakedObjectSpecification[] types;
    private final NakedReference target;
    private final boolean[] optional;
    private final Naked[][] options;
    private final int[] noLines;
    private final int[] maxLengths;
    private final int[] typicalLength;
    private final String[] descriptions;
    private final boolean[] canWrap;

    public static ActionHelper createInstance(NakedReference target, NakedObjectAction action) {
        int i;
        int numberParameters = action.getParameterTypes().length;
        Naked[] parameters = new Naked[numberParameters];
        String[] names = action.getParameterNames();
        String[] descriptions = action.getParameterDescriptions();
        Naked[] defaultValues = action.getDefaultParameterValues(target);
        Naked[][] options = action.getOptions(target);
        boolean[] optional = action.getOptionalParameters();
        NakedObjectSpecification[] parameterTypes = action.getParameterTypes();
        Naked[] values = new Naked[parameterTypes.length];
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            values[i2] = parameterTypes[i2].getType() == 273 ? NakedObjectsContext.getObjectLoader().createValueInstance(parameterTypes[i2]) : null;
        }
        Naked[] parameterValues = new Naked[parameterTypes.length];
        for (i = 0; i < parameterValues.length; ++i) {
            parameterValues[i] = values[i];
        }
        for (i = 0; i < numberParameters; ++i) {
            parameters[i] = defaultValues[i] == null ? parameterValues[i] : defaultValues[i];
        }
        int[] maxLength = action.getParameterMaxLengths();
        int[] typicalLength = action.getParameterTypicalLengths();
        int[] noLines = action.getParameterNoLines();
        boolean[] canWrap = action.canParametersWrap();
        return new ActionHelper(target, action, names, descriptions, parameters, parameterTypes, optional, options, noLines, canWrap, maxLength, typicalLength);
    }

    private ActionHelper(NakedReference target, NakedObjectAction action, String[] names, String[] descriptions, Naked[] parameters, NakedObjectSpecification[] types, boolean[] optional, Naked[][] options, int[] noLines, boolean[] canWrap, int[] maxLengths, int[] typicalLength) {
        this.target = target;
        this.action = action;
        this.names = names;
        this.descriptions = descriptions;
        this.parameters = parameters;
        this.types = types;
        this.optional = optional;
        this.options = options;
        this.noLines = noLines;
        this.canWrap = canWrap;
        this.maxLengths = maxLengths;
        this.typicalLength = typicalLength;
    }

    public ParameterContent[] createParameters() {
        ParameterContent[] parameterContents = new ParameterContent[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            parameterContents[i] = this.types[i].getType() == 273 ? new ValueParameterImpl(this.names[i], this.descriptions[i], this.parameters[i], this.types[i], !this.optional[i], (NakedValue[])this.options[i], this.noLines[i], this.canWrap[i], this.maxLengths[i], this.typicalLength[i]) : new ObjectParameterImpl(this.names[i], this.descriptions[i], this.parameters[i], this.types[i], !this.optional[i], (NakedObject[])this.options[i], i, this);
        }
        return parameterContents;
    }

    public Consent disabled() {
        return this.action.isParameterSetValid(this.target, this.parameters);
    }

    public String getName() {
        return this.action.getName();
    }

    public String getDescription() {
        return this.action.getDescription();
    }

    public String getHelp() {
        return this.action.getHelp();
    }

    public Naked getParameter(int index) {
        return this.parameters[index];
    }

    public NakedReference getTarget() {
        return this.action.realTarget(this.target);
    }

    public Naked invoke() {
        return this.action.execute(this.target, this.parameters);
    }

    public void setParameter(int index, Naked parameter) {
        this.parameters[index] = parameter;
    }

    public String title() {
        return this.getTarget().titleString();
    }

    public String getIconName() {
        return this.getTarget().getIconName();
    }
}

