/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.noa.spec.Features;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nof.core.util.UnknownTypeException;
import org.nakedobjects.nos.client.dnd.BackgroundTask;
import org.nakedobjects.nos.client.dnd.BackgroundThread;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.content.AbstractContent;
import org.nakedobjects.nos.client.dnd.content.AbstractObjectOption;
import org.nakedobjects.nos.client.dnd.content.ActionHelper;
import org.nakedobjects.nos.client.dnd.content.CollectionActionContent;
import org.nakedobjects.nos.client.dnd.content.ObjectActionContent;
import org.nakedobjects.nos.client.dnd.drawing.Location;

public class DialoggedObjectOption
extends AbstractObjectOption {
    public static DialoggedObjectOption createOption(NakedObjectAction action, NakedReference object) {
        int paramCount = action.getParameterCount();
        Assert.assertTrue((String)"Only for actions taking one or more params", (paramCount > 0 ? 1 : 0) != 0);
        if (!action.isVisible() || !action.isVisible(object)) {
            return null;
        }
        DialoggedObjectOption option = new DialoggedObjectOption(action, object);
        return option;
    }

    private DialoggedObjectOption(NakedObjectAction action, NakedReference target) {
        super(action, target, action.getName() + "...");
    }

    public void execute(final Workspace workspace, final View view, Location at) {
        BackgroundThread.run(view, new BackgroundTask(){

            public void execute() {
                AbstractContent content;
                ActionHelper helper = ActionHelper.createInstance(DialoggedObjectOption.this.target, DialoggedObjectOption.this.action);
                if (DialoggedObjectOption.this.target instanceof NakedObject || DialoggedObjectOption.this.target == null && Features.isService((NakedObjectSpecification)DialoggedObjectOption.this.action.getOnType())) {
                    content = new ObjectActionContent(helper);
                } else if (DialoggedObjectOption.this.target instanceof NakedCollection) {
                    content = new CollectionActionContent(helper);
                } else {
                    throw new UnknownTypeException((Object)DialoggedObjectOption.this.target);
                }
                View dialog = Toolkit.getViewFactory().createDialog(content);
                Location loc = view.getAbsoluteLocation();
                dialog.setLocation(loc);
                workspace.addView(dialog);
            }

            public String getDescription() {
                return "Preparing action " + this.getName() + " on  " + view.getContent().getNaked();
            }

            public String getName() {
                return "Preparing action " + DialoggedObjectOption.this.action.getName();
            }
        });
    }
}

