/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nos.client.dnd.BackgroundTask;
import org.nakedobjects.nos.client.dnd.BackgroundThread;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.content.AbstractObjectOption;
import org.nakedobjects.nos.client.dnd.drawing.Location;

public class ImmediateObjectOption
extends AbstractObjectOption {
    public static ImmediateObjectOption createOption(NakedObjectAction action, NakedReference object) {
        Assert.assertTrue((String)"Only suitable for 0 param methods", (action.getParameterTypes().length == 0 ? 1 : 0) != 0);
        if (!action.isVisible() || !action.isVisible(object)) {
            return null;
        }
        ImmediateObjectOption option = new ImmediateObjectOption(action, object);
        return option;
    }

    public static ImmediateObjectOption createServiceOption(NakedObjectAction action, NakedReference object) {
        Assert.assertTrue((String)"Only suitable for 1 param methods", (action.getParameterTypes().length == 1 ? 1 : 0) != 0);
        if (!action.isVisible() || !action.isVisible(object)) {
            return null;
        }
        ImmediateObjectOption option = new ImmediateObjectOption(action, object);
        return option;
    }

    private ImmediateObjectOption(NakedObjectAction action, NakedReference target) {
        super(action, target, action.getName());
    }

    protected Consent checkValid() {
        return this.action.isParameterSetValid(this.target, null);
    }

    public void execute(Workspace workspace, final View view, final Location at) {
        BackgroundThread.newRun(view, new BackgroundTask(){

            public void execute() {
                Naked result = ImmediateObjectOption.this.action.execute(ImmediateObjectOption.this.target, null);
                if (result != null) {
                    NakedCollection collection;
                    if (result instanceof NakedCollection && (collection = (NakedCollection)result).size() == 1) {
                        result = collection.firstElement();
                    }
                    view.objectActionResult(result, at);
                }
                view.getViewManager().disposeUnneededViews();
                view.getFeedbackManager().showMessagesAndWarnings();
            }

            public String getDescription() {
                return "Running action " + this.getName() + " on  " + view.getContent().getNaked();
            }

            public String getName() {
                return "NakedObjectAction " + ImmediateObjectOption.this.action.getName();
            }
        });
    }
}

