/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.ToString;
import org.nakedobjects.nos.client.dnd.ObjectParameter;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.content.AbstractObjectContent;
import org.nakedobjects.nos.client.dnd.content.ActionHelper;
import org.nakedobjects.nos.client.dnd.content.OptionFactory;
import org.nakedobjects.nos.client.dnd.drawing.Location;

public class ObjectParameterImpl
extends AbstractObjectContent
implements ObjectParameter {
    private final NakedObject object;
    private final String name;
    private final NakedObjectSpecification specification;
    private final ActionHelper invocation;
    private final int i;
    private final boolean isRequired;
    private final NakedObject[] options;
    private final String description;

    public ObjectParameterImpl(String name, String description, Naked naked, NakedObjectSpecification specification, boolean required, NakedObject[] options, int i, ActionHelper invocation) {
        this.name = name;
        this.description = description;
        this.specification = specification;
        this.isRequired = required;
        this.options = options;
        this.i = i;
        this.invocation = invocation;
        this.object = (NakedObject)naked;
    }

    public ObjectParameterImpl(ObjectParameterImpl content, NakedObject object) {
        this.name = content.name;
        this.description = content.description;
        this.specification = content.specification;
        this.isRequired = content.isRequired;
        this.options = content.options;
        this.i = content.i;
        this.invocation = content.invocation;
        this.object = object;
    }

    public Consent canClear() {
        return Allow.DEFAULT;
    }

    public Consent canSet(NakedObject dragSource) {
        if (dragSource.getSpecification().isOfType(this.specification)) {
            return Allow.DEFAULT;
        }
        return new Veto("Object must be " + this.specification.getShortName());
    }

    public void clear() {
        this.setObject(null);
    }

    public void debugDetails(DebugString debug) {
        debug.appendln("name", (Object)this.name);
        debug.appendln("required", this.isRequired);
        debug.appendln("object", (Object)this.object);
    }

    public Naked getNaked() {
        return this.object;
    }

    public NakedObject getObject() {
        return this.object;
    }

    public Naked[] getOptions() {
        return this.options;
    }

    public boolean isObject() {
        return true;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean isPersistable() {
        return false;
    }

    public boolean isOptionEnabled() {
        return this.options != null;
    }

    public boolean isTransient() {
        return this.object != null && this.object.getResolveState().isTransient();
    }

    public void contentMenuOptions(UserActionSet options) {
        if (this.object != null) {
            options.add(new AbstractUserAction("Clear parameter"){

                public void execute(Workspace workspace, View view, Location at) {
                    ObjectParameterImpl.this.clear();
                    view.getParent().invalidateContent();
                }
            });
            OptionFactory.addObjectMenuOptions((NakedReference)this.object, options);
        } else {
            OptionFactory.addCreateOptions(this.specification, options);
        }
    }

    public void setObject(NakedObject object) {
        this.invocation.setParameter(this.i, (Naked)object);
    }

    public String title() {
        return this.object == null ? "" : this.object.titleString();
    }

    public String toString() {
        ToString toString = new ToString((Object)this);
        toString.append("label", this.name);
        toString.append("required", this.isRequired);
        toString.append("spec", this.getSpecification().getFullName());
        toString.append("object", this.object == null ? "null" : this.object.titleString());
        return toString.toString();
    }

    public String getParameterName() {
        return this.name;
    }

    public NakedObjectSpecification getSpecification() {
        return this.specification;
    }

    public String getDescription() {
        String title = this.object == null ? "" : ": " + this.object.titleString();
        String type = this.name.indexOf(this.specification.getShortName()) == -1 ? " (" + this.specification.getShortName() + ")" : "";
        return this.name + type + title + " " + this.description;
    }

    public String getHelp() {
        return this.invocation.getHelp();
    }

    public String getId() {
        return null;
    }
}

