/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.content;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.OneToManyAssociation;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.OneToManyFieldElement;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.content.AbstractObjectContent;
import org.nakedobjects.nos.client.dnd.content.ClearOneToManyAssociationOption;
import org.nakedobjects.nos.client.dnd.content.ObjectField;

public class OneToManyFieldElementImpl
extends AbstractObjectContent
implements OneToManyFieldElement {
    private static final Logger LOG = Logger.getLogger(OneToManyFieldElementImpl.class);
    private final NakedObject element;
    private final ObjectField field;

    public OneToManyFieldElementImpl(NakedObject parent, NakedObject element, OneToManyAssociation association) {
        this.field = new ObjectField(parent, (NakedObjectField)association);
        this.element = element;
    }

    public Consent canClear() {
        NakedObject parentObject = this.getParent();
        OneToManyAssociation association = this.getOneToManyAssociation();
        NakedObject associatedObject = this.getObject();
        Consent isEditable = this.isEditable();
        if (isEditable.isVetoed()) {
            return isEditable;
        }
        Consent isValid = association.isValidToRemove(parentObject, associatedObject);
        if (isValid.isAllowed()) {
            String status = "Clear the association to this object from '" + parentObject.titleString() + "'";
            return new Allow(status);
        }
        return new Veto(isValid.getReason());
    }

    public Consent isEditable() {
        Consent usable = this.getField().isUsable();
        if (usable.isVetoed()) {
            return usable;
        }
        return this.getField().isUsable((NakedReference)this.getParent());
    }

    public Consent canSet(NakedObject dragSource) {
        return Veto.DEFAULT;
    }

    public void clear() {
        NakedObject parentObject = this.getParent();
        OneToManyAssociation association = this.getOneToManyAssociation();
        LOG.debug((Object)("remove " + this.element + " from " + parentObject));
        association.removeElement(parentObject, this.element);
    }

    public void debugDetails(DebugString debug) {
        this.field.debugDetails(debug);
        debug.appendln("element", (Object)this.element);
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public NakedObjectField getField() {
        return this.field.getFieldReflector();
    }

    public Naked getNaked() {
        return this.element;
    }

    public NakedObject getObject() {
        return this.element;
    }

    public Naked[] getOptions() {
        return null;
    }

    private OneToManyAssociation getOneToManyAssociation() {
        return (OneToManyAssociation)this.field.getFieldReflector();
    }

    public NakedObject getParent() {
        return this.field.getParent();
    }

    public NakedObjectSpecification getSpecification() {
        return this.field.getSpecification();
    }

    public boolean isMandatory() {
        return false;
    }

    public boolean isObject() {
        return true;
    }

    public boolean isOptionEnabled() {
        return false;
    }

    public boolean isTransient() {
        return false;
    }

    public void contentMenuOptions(UserActionSet options) {
        super.contentMenuOptions(options);
        options.add(new ClearOneToManyAssociationOption());
    }

    public void setObject(NakedObject object) {
    }

    public String title() {
        return this.element.titleString();
    }

    public String toString() {
        return this.getObject() + "/" + this.field.getFieldReflector();
    }

    public String windowTitle() {
        return this.field.getName() + " element" + " for " + this.field.getParent().titleString();
    }

    public String getId() {
        return this.getOneToManyAssociation().getName();
    }

    public String getDescription() {
        return this.field.getName() + ": " + this.getOneToManyAssociation().getDescription();
    }

    public String getHelp() {
        return this.getOneToManyAssociation().getHelp();
    }
}

