/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.OneToManyAssociation;
import org.nakedobjects.noa.spec.Features;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.OneToManyField;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.content.AbstractCollectionContent;
import org.nakedobjects.nos.client.dnd.content.ObjectField;
import org.nakedobjects.nos.client.dnd.content.OptionFactory;
import org.nakedobjects.nos.client.dnd.drawing.Image;
import org.nakedobjects.nos.client.dnd.image.ImageFactory;

public class OneToManyFieldImpl
extends AbstractCollectionContent
implements OneToManyField {
    private final NakedCollection collection;
    private final ObjectField field;

    public OneToManyFieldImpl(NakedObject parent, NakedCollection object, OneToManyAssociation association) {
        this.field = new ObjectField(parent, (NakedObjectField)association);
        this.collection = object;
    }

    public Consent canClear() {
        return Veto.DEFAULT;
    }

    public Consent canDrop(Content sourceContent) {
        if (sourceContent.getNaked() instanceof NakedObject) {
            NakedObject object = (NakedObject)sourceContent.getNaked();
            NakedObject parent = this.field.getParent();
            NakedCollection collection = (NakedCollection)this.getNaked();
            if (collection == null) {
                return new Veto("Collection not set up; can't add elements to a non-existant collection");
            }
            Consent usableByUser = this.getOneToManyAssociation().isUsable();
            if (usableByUser.isVetoed()) {
                return usableByUser;
            }
            Consent usableInState = this.getOneToManyAssociation().isUsable((NakedReference)parent);
            if (usableInState.isVetoed()) {
                return usableInState;
            }
            NakedObjectSpecification specification = object.getSpecification();
            if (!specification.isOfType(collection.getElementSpecification())) {
                return new Veto("Only objects of type " + collection.getElementSpecification().getSingularName() + " are allowed in this collection");
            }
            if (parent.getResolveState().isPersistent() && object.getResolveState().isTransient()) {
                return new Veto("Can't set field in persistent object with reference to non-persistent object");
            }
            if (Features.isAggregated((NakedObjectSpecification)specification) && specification.getAggregate(object) != this.getParent()) {
                return new Veto("Object is already associated with another object: " + specification.getAggregate(object));
            }
            return this.getOneToManyAssociation().isValidToAdd(parent, object);
        }
        return Veto.DEFAULT;
    }

    public Consent canSet(NakedObject dragSource) {
        return Veto.DEFAULT;
    }

    public void clear() {
        throw new NakedObjectRuntimeException("Invalid call");
    }

    public void contentMenuOptions(UserActionSet options) {
        super.contentMenuOptions(options);
        OptionFactory.addCreateOptions(this.getOneToManyAssociation().getSpecification(), options);
    }

    public void debugDetails(DebugString debug) {
        this.field.debugDetails(debug);
        debug.appendln("collection", (Object)this.collection);
        super.debugDetails(debug);
    }

    public Naked drop(Content sourceContent) {
        NakedObject object = (NakedObject)sourceContent.getNaked();
        NakedObject parent = this.field.getParent();
        Consent perm = this.canDrop(sourceContent);
        if (perm.isAllowed()) {
            this.getOneToManyAssociation().addElement(parent, object);
        }
        return null;
    }

    public NakedCollection getCollection() {
        return this.collection;
    }

    public String getDescription() {
        String type;
        String name = this.getFieldName();
        type = name.indexOf(type = this.getField().getSpecification().getSingularName()) == -1 ? " (" + type + ")" : "";
        String description = this.getOneToManyAssociation().getDescription();
        return name + type + " " + description;
    }

    public NakedObjectField getField() {
        return this.field.getFieldReflector();
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public String getHelp() {
        return this.getOneToManyAssociation().getHelp();
    }

    public String getIconName() {
        return null;
    }

    public Image getIconPicture(int iconHeight) {
        NakedObjectSpecification specification = this.getOneToManyAssociation().getSpecification();
        Image icon = ImageFactory.getInstance().loadIcon(specification, iconHeight, null);
        if (icon == null) {
            icon = ImageFactory.getInstance().loadDefaultIcon(iconHeight, null);
        }
        return icon;
    }

    public String getId() {
        return this.getOneToManyAssociation().getId();
    }

    public Naked getNaked() {
        return this.collection;
    }

    public OneToManyAssociation getOneToManyAssociation() {
        return (OneToManyAssociation)this.field.getFieldReflector();
    }

    public NakedObject getParent() {
        return this.field.getParent();
    }

    public NakedObjectSpecification getSpecification() {
        return this.field.getSpecification();
    }

    public boolean isCollection() {
        return true;
    }

    public boolean isMandatory() {
        return this.getOneToManyAssociation().isMandatory();
    }

    public boolean isTransient() {
        return false;
    }

    public void setObject(NakedObject object) {
        throw new NakedObjectRuntimeException("Invalid call");
    }

    public final String title() {
        return this.field.getName();
    }

    public String toString() {
        return this.collection + "/" + this.field.getFieldReflector();
    }

    public String windowTitle() {
        return this.title() + " for " + this.field.getParent().titleString();
    }
}

