/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.OneToOneAssociation;
import org.nakedobjects.noa.spec.Features;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.OneToOneField;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.content.AbstractObjectContent;
import org.nakedobjects.nos.client.dnd.content.ClearOneToOneAssociationOption;
import org.nakedobjects.nos.client.dnd.content.ObjectField;

public class OneToOneFieldImpl
extends AbstractObjectContent
implements OneToOneField {
    private static final UserAction CLEAR_ASSOCIATION = new ClearOneToOneAssociationOption();
    private final ObjectField field;
    private final NakedObject object;

    public OneToOneFieldImpl(NakedObject parent, NakedObject object, OneToOneAssociation association) {
        this.field = new ObjectField(parent, (NakedObjectField)association);
        this.object = object;
    }

    public Consent canClear() {
        NakedObject parentObject = this.getParent();
        OneToOneAssociation association = this.getOneToOneAssociation();
        Consent isEditable = this.isEditable();
        if (isEditable.isVetoed()) {
            return isEditable;
        }
        Consent isValid = association.isAssociationValid(parentObject, null);
        if (isValid.isAllowed()) {
            String status = "Clear the association to this object from '" + parentObject.titleString() + "'";
            return new Allow(status);
        }
        return new Veto(isValid.getReason());
    }

    public Consent canSet(NakedObject object) {
        NakedObjectSpecification targetType = this.getOneToOneAssociation().getSpecification();
        NakedObjectSpecification spec = object.getSpecification();
        if (this.isEditable().isVetoed()) {
            return this.isEditable();
        }
        if (!spec.isOfType(targetType)) {
            return new Veto("Can only drop objects of type " + targetType.getSingularName());
        }
        if (this.getParent().getResolveState().isPersistent() && object.getResolveState().isTransient()) {
            return new Veto("Can't drop a non-persistent into this persistent object");
        }
        if (Features.isAggregated((NakedObjectSpecification)spec) && spec.getAggregate(object) != this.getParent()) {
            return new Veto("Object is already associated with another object: " + spec.getAggregate(object));
        }
        Consent perm = this.getOneToOneAssociation().isAssociationValid(this.getParent(), object);
        return perm;
    }

    public void clear() {
        this.getOneToOneAssociation().clearAssociation(this.getParent(), this.object);
    }

    public void debugDetails(DebugString debug) {
        this.field.debugDetails(debug);
        debug.appendln("object", (Object)this.object);
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public NakedObjectField getField() {
        return this.field.getFieldReflector();
    }

    public Consent isEditable() {
        Consent usable = this.getField().isUsable();
        if (usable.isVetoed()) {
            return usable;
        }
        return this.getField().isUsable((NakedReference)this.getParent());
    }

    public Naked getNaked() {
        return this.object;
    }

    public NakedObject getObject() {
        return this.object;
    }

    private OneToOneAssociation getOneToOneAssociation() {
        return (OneToOneAssociation)this.getField();
    }

    public Naked[] getOptions() {
        return (NakedObject[])this.getOneToOneAssociation().getOptions(this.getParent());
    }

    public NakedObject getParent() {
        return this.field.getParent();
    }

    public NakedObjectSpecification getSpecification() {
        return this.getOneToOneAssociation().getSpecification();
    }

    public boolean isMandatory() {
        return this.getOneToOneAssociation().isMandatory();
    }

    public boolean isPersistable() {
        return this.getObject() != null && super.isPersistable();
    }

    public boolean isObject() {
        return true;
    }

    public boolean isOptionEnabled() {
        return this.getOneToOneAssociation().isOptionEnable();
    }

    public boolean isTransient() {
        return this.object != null && this.object.getResolveState().isTransient();
    }

    public void contentMenuOptions(UserActionSet options) {
        super.contentMenuOptions(options);
        if (this.getObject() != null && !this.getOneToOneAssociation().isMandatory()) {
            options.add(CLEAR_ASSOCIATION);
        }
    }

    public void setObject(NakedObject object) {
        this.getOneToOneAssociation().setAssociation(this.getParent(), object);
    }

    public String title() {
        return this.object == null ? "" : this.object.titleString();
    }

    public String toString() {
        return this.getObject() + "/" + this.getField();
    }

    public String windowTitle() {
        return this.field.getName() + " for " + this.field.getParent().titleString();
    }

    public String getId() {
        return this.getOneToOneAssociation().getName();
    }

    public String getDescription() {
        String type;
        String name = this.getFieldName();
        type = name.indexOf(type = this.getField().getSpecification().getSingularName()) == -1 ? " (" + type + ")" : "";
        String description = this.getOneToOneAssociation().getDescription();
        return name + type + " " + description;
    }

    public String getHelp() {
        return this.getOneToOneAssociation().getHelp();
    }
}

