/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.noa.spec.Features;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.adapter.InstanceCollectionVector;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.action.DisposeObjectOption;
import org.nakedobjects.nos.client.dnd.content.DialoggedObjectOption;
import org.nakedobjects.nos.client.dnd.content.ImmediateObjectOption;

public class OptionFactory {
    public static void addCreateOptions(NakedObjectSpecification specificaton, UserActionSet options) {
        NakedObjectAction[] actions = specificaton.getClassActions(NakedObjectAction.USER);
        OptionFactory.menuOptions(actions, null, options);
    }

    public static void addObjectMenuOptions(NakedReference object, UserActionSet options) {
        if (object != null) {
            boolean isPersistent;
            NakedObjectAction[] actions1 = object.getSpecification().getObjectActions(NakedObjectAction.USER);
            NakedObjectAction[] actions2 = object.getSpecification().getObjectActions(NakedObjectAction.EXPLORATION);
            NakedObjectAction[] actions3 = object.getSpecification().getObjectActions(NakedObjectAction.DEBUG);
            NakedObjectAction[] actions = new NakedObjectAction[actions1.length + actions2.length + actions3.length];
            System.arraycopy(actions1, 0, actions, 0, actions1.length);
            System.arraycopy(actions2, 0, actions, actions1.length, actions2.length);
            System.arraycopy(actions3, 0, actions, actions1.length + actions2.length, actions3.length);
            OptionFactory.menuOptions(actions, object, options);
            Oid oid = object.getOid();
            boolean bl = isPersistent = oid != null && !oid.isTransient();
            if (!Features.isService((NakedObjectSpecification)object.getSpecification()) && !(object.getObject() instanceof InstanceCollectionVector) && isPersistent) {
                options.add(new DisposeObjectOption());
            }
        }
    }

    private static void menuOptions(NakedObjectAction[] actions, NakedReference target, UserActionSet menuOptionSet) {
        for (int i = 0; i < actions.length; ++i) {
            UserAction option = null;
            if (actions[i].getActions().length > 0) {
                option = new UserActionSet(actions[i].getName(), menuOptionSet);
                OptionFactory.menuOptions(actions[i].getActions(), target, option);
            } else {
                int noOfParameters = actions[i].getParameterTypes().length;
                option = noOfParameters == 0 ? ImmediateObjectOption.createOption(actions[i], target) : (actions[i].isContributedMethodWithSuitableParameter() && noOfParameters == 1 && target != null && target.getSpecification().isOfType(actions[i].getParameterTypes()[0]) ? ImmediateObjectOption.createServiceOption(actions[i], target) : DialoggedObjectOption.createOption(actions[i], target));
            }
            if (option == null) continue;
            menuOptionSet.add(option);
        }
    }
}

