/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.adapter.InvalidEntryException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.ValueAssociation;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ValueField;
import org.nakedobjects.nos.client.dnd.content.AbstractValueContent;
import org.nakedobjects.nos.client.dnd.content.ObjectField;

public class ValueFieldImpl
extends AbstractValueContent
implements ValueField {
    private final ObjectField field;
    private final NakedValue valueAdapter;

    public ValueFieldImpl(NakedObject parent, NakedValue object, ValueAssociation association) {
        this.field = new ObjectField(parent, (NakedObjectField)association);
        Assert.assertNotNull((Object)object);
        this.valueAdapter = object;
    }

    public Consent canDrop(Content sourceContent) {
        return Veto.DEFAULT;
    }

    public boolean canClear() {
        return this.getValueAssociation().canClear();
    }

    public boolean canWrap() {
        return this.getValueAssociation().canWrap();
    }

    public void clear() {
        this.valueAdapter.clear();
    }

    public void debugDetails(DebugString debug) {
        this.field.debugDetails(debug);
        debug.appendln("object", (Object)this.valueAdapter);
    }

    public Naked drop(Content sourceContent) {
        return null;
    }

    public void entryComplete() {
        if (this.valueAdapter.isEmpty()) {
            this.getValueAssociation().clearValue(this.getParent());
        } else {
            this.getValueAssociation().setValue(this.getParent(), this.valueAdapter);
        }
    }

    public String getDescription() {
        String title = this.valueAdapter == null ? "" : ": " + this.valueAdapter.titleString();
        String name = this.field.getName();
        NakedObjectSpecification specification = this.getSpecification();
        String type = name.indexOf(specification.getShortName()) == -1 ? "" : " (" + specification.getShortName() + ")";
        String description = this.getValueAssociation().getDescription();
        return name + type + title + " " + description;
    }

    public String getHelp() {
        return this.field.getHelp();
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public NakedObjectField getField() {
        return this.field.getFieldReflector();
    }

    public String getIconName() {
        return this.valueAdapter.getIconName();
    }

    public Naked getNaked() {
        return this.valueAdapter;
    }

    public String getId() {
        return this.field.getName();
    }

    public NakedValue getObject() {
        return this.valueAdapter;
    }

    public Naked[] getOptions() {
        return this.getValueAssociation().getOptions(this.getParent());
    }

    private ValueAssociation getValueAssociation() {
        return (ValueAssociation)this.getField();
    }

    public int getMaximumLength() {
        return this.getValueAssociation().getMaximumLength();
    }

    public int getTypicalLineLength() {
        return this.getValueAssociation().getTypicalLineLength();
    }

    public int getNoLines() {
        return this.getValueAssociation().getNoLines();
    }

    public NakedObject getParent() {
        return this.field.getParent();
    }

    public NakedObjectSpecification getSpecification() {
        return this.getValueAssociation().getSpecification();
    }

    public Consent isEditable() {
        Consent usable = this.getValueAssociation().isUsable();
        if (usable.isVetoed()) {
            return usable;
        }
        return this.getValueAssociation().isUsable((NakedReference)this.getParent());
    }

    public boolean isEmpty() {
        return this.getField().isEmpty(this.getParent());
    }

    public boolean isMandatory() {
        return this.getValueAssociation().isMandatory();
    }

    public boolean isOptionEnabled() {
        return this.getValueAssociation().isOptionEnable();
    }

    public void parseTextEntry(String entryText) {
        String existingEntry = this.valueAdapter.asEncodedString();
        this.valueAdapter.parseTextEntry(entryText);
        Consent valid = ((ValueAssociation)this.getField()).isValueValid(this.getParent(), this.valueAdapter);
        if (valid.isVetoed()) {
            this.valueAdapter.restoreFromEncodedString(existingEntry);
            throw new InvalidEntryException(valid.getReason());
        }
        if (this.getValueAssociation().isMandatory() && this.valueAdapter.isEmpty()) {
            this.valueAdapter.restoreFromEncodedString(existingEntry);
            throw new InvalidEntryException("Mandatory field cannot be empty");
        }
    }

    public String title() {
        return this.field.getName();
    }

    public String toString() {
        return (this.valueAdapter == null ? "null" : this.valueAdapter.titleString()) + "/" + this.getField();
    }

    public String windowTitle() {
        return this.title();
    }
}

