/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.ToString;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ValueParameter;
import org.nakedobjects.nos.client.dnd.content.AbstractValueContent;
import org.nakedobjects.nos.client.dnd.drawing.Image;
import org.nakedobjects.nos.client.dnd.image.ImageFactory;

public class ValueParameterImpl
extends AbstractValueContent
implements ValueParameter {
    private final NakedValue object;
    private final String name;
    private final NakedObjectSpecification specification;
    private final boolean isRequired;
    private final NakedValue[] options;
    private int noLines;
    private int typicalLength;
    private int maxLength;
    private final String description;
    private final boolean canWrap;

    public ValueParameterImpl(String name, String description, Naked naked, NakedObjectSpecification specification, boolean required, NakedValue[] options, int noLines, boolean canWrap, int maxLength, int typicalLength) {
        this.name = name;
        this.description = description;
        this.specification = specification;
        this.isRequired = required;
        this.options = options;
        this.noLines = noLines;
        this.canWrap = canWrap;
        this.maxLength = maxLength;
        this.typicalLength = typicalLength;
        this.object = (NakedValue)naked;
    }

    public void debugDetails(DebugString debug) {
        debug.appendln("name", (Object)this.name);
        debug.appendln("required", this.isRequired);
        debug.appendln("object", (Object)this.object);
    }

    public void entryComplete() {
    }

    public String getIconName() {
        return "";
    }

    public Image getIconPicture(int iconHeight) {
        return ImageFactory.getInstance().loadIcon("value", 12, null);
    }

    public Naked getNaked() {
        return this.object;
    }

    public int getNoLines() {
        return this.noLines;
    }

    public NakedValue getObject() {
        return this.object;
    }

    public Naked[] getOptions() {
        return this.options;
    }

    public boolean isEmpty() {
        return this.object.isEmpty();
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean canClear() {
        return true;
    }

    public boolean canWrap() {
        return this.canWrap;
    }

    public void clear() {
        this.object.clear();
    }

    public boolean isTransient() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public boolean isOptionEnabled() {
        return this.options != null && this.options.length > 0;
    }

    public String title() {
        return this.object.titleString();
    }

    public String toString() {
        ToString toString = new ToString((Object)this);
        toString.append("object", (Object)this.object);
        return toString.toString();
    }

    public String getParameterName() {
        return this.name;
    }

    public NakedObjectSpecification getSpecification() {
        return this.specification;
    }

    public Naked drop(Content sourceContent) {
        return null;
    }

    public Consent canDrop(Content sourceContent) {
        return Veto.DEFAULT;
    }

    public void parseTextEntry(String entryText) {
        this.object.parseTextEntry(entryText);
    }

    public String getDescription() {
        String title = this.object == null ? "" : ": " + this.object.titleString();
        String type = this.name.indexOf(this.specification.getShortName()) == -1 ? "" : " (" + this.specification.getShortName() + ")";
        return this.name + type + title + " " + this.description;
    }

    public String getHelp() {
        return null;
    }

    public String getId() {
        return null;
    }

    public Consent isEditable() {
        return Allow.DEFAULT;
    }

    public int getMaximumLength() {
        return this.maxLength;
    }

    public int getTypicalLineLength() {
        return this.typicalLength;
    }
}

