/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.debug;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.Dump;
import org.nakedobjects.nos.client.dnd.CollectionContent;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.debug.DebugCanvas;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;

public class DebugView
implements DebugInfo {
    private final View view;

    public DebugView(View display) {
        this.view = display;
    }

    public void debugData(DebugString debug) {
        debug.append((Object)this.view.getView());
        debug.blankLine();
        debug.blankLine();
        debug.appendTitle("VIEW");
        this.view.debug(debug);
        debug.appendln();
        Content content = this.view.getContent();
        debug.appendTitle("CONTENT");
        if (content != null) {
            String type = content.getClass().getName();
            type = type.substring(type.lastIndexOf(46) + 1);
            debug.appendln("Content", (Object)type);
            content.debugDetails(debug);
            debug.indent();
            debug.appendln("Icon name", (Object)content.getIconName());
            debug.appendln("Icon ", (Object)content.getIconPicture(32));
            debug.appendln("Window title", (Object)content.windowTitle());
            debug.appendln("Persistable", content.isPersistable());
            debug.appendln("Object", content.isObject());
            debug.appendln("Collection", content.isCollection());
            debug.appendln("Value", content.isValue());
            debug.unindent();
        } else {
            debug.appendln("Content", (Object)"none");
        }
        debug.blankLine();
        if (content instanceof ObjectContent) {
            NakedObject object = ((ObjectContent)content).getObject();
            this.dumpObject((Naked)object, debug);
            debug.blankLine();
            this.dumpSpecification((Naked)object, debug);
            debug.blankLine();
            this.dumpGraph((Naked)object, debug);
        } else if (content instanceof CollectionContent) {
            NakedCollection collection = ((CollectionContent)((Object)content)).getCollection();
            debug.blankLine();
            this.dumpObject((Naked)collection, debug);
            this.dumpSpecification((Naked)collection, debug);
            debug.blankLine();
            this.dumpGraph((Naked)collection, debug);
        }
        debug.append((Object)"\n\nDRAWING\n");
        debug.append((Object)"------\n");
        this.view.draw(new DebugCanvas(debug, new Bounds(this.view.getBounds())));
    }

    public String debugTitle() {
        return "Debug: " + this.view + this.view == null ? "" : "/" + this.view.getContent();
    }

    public void dumpGraph(Naked object, DebugString info) {
        if (object != null) {
            info.appendTitle("GRAPH");
            Dump.graph((Naked)object, (DebugString)info);
        }
    }

    public void dumpObject(Naked object, DebugString info) {
        if (object != null) {
            info.appendTitle("OBJECT");
            Dump.adapter((Naked)object, (DebugString)info);
        }
    }

    private void dumpSpecification(Naked object, DebugString info) {
        if (object != null) {
            info.appendTitle("SPECIFICATION");
            Dump.specification((Naked)object, (DebugString)info);
        }
    }
}

