/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.drawing;

public class Shape {
    int count = 0;
    int[] x = new int[6];
    int[] y = new int[6];

    public Shape() {
    }

    public Shape(int xOrigin, int yOrigin) {
        this.x[0] = xOrigin;
        this.y[0] = yOrigin;
        this.count = 1;
    }

    public Shape(Shape shape) {
        this.count = shape.count;
        this.x = new int[this.count];
        this.y = new int[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.x[i] = shape.x[i];
            this.y[i] = shape.y[i];
        }
    }

    public void extendsLine(int width, int height) {
        int x = this.x[this.count - 1] + width;
        int y = this.y[this.count - 1] + height;
        this.addVertex(x, y);
    }

    public void addVertex(int x, int y) {
        if (this.x.length == this.count) {
            int[] newX = new int[this.count * 2];
            int[] newY = new int[this.count * 2];
            System.arraycopy(this.x, 0, newX, 0, this.count);
            System.arraycopy(this.y, 0, newY, 0, this.count);
            this.x = newX;
            this.y = newY;
        }
        this.x[this.count] = x;
        this.y[this.count] = y;
        ++this.count;
    }

    public int count() {
        return this.count;
    }

    public int[] getX() {
        int[] xx = new int[this.count];
        System.arraycopy(this.x, 0, xx, 0, this.count);
        return xx;
    }

    public int[] getY() {
        int[] yy = new int[this.count];
        System.arraycopy(this.y, 0, yy, 0, this.count);
        return yy;
    }

    public String toString() {
        StringBuffer points = new StringBuffer();
        for (int i = 0; i < this.count; ++i) {
            if (i > 0) {
                points.append("; ");
            }
            points.append(this.x[i]);
            points.append(",");
            points.append(this.y[i]);
        }
        return "Shape {" + points + "}";
    }

    public void translate(int x, int y) {
        int i = 0;
        while (i < this.count) {
            int n = i;
            this.x[n] = this.x[n] + x;
            int n2 = i++;
            this.y[n2] = this.y[n2] + y;
        }
    }
}

