/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.image;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.util.Hashtable;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.image.TemplateImage;
import org.nakedobjects.nof.core.image.TemplateImageLoader;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.image.AwtImage;

public class ImageFactory {
    private static final String DEFAULT_IMAGE_NAME = "Default";
    private static final String DEFAULT_IMAGE_PROPERTY = "nakedobjects.viewer.dnd.default-image";
    private static ImageFactory instance;
    private static final String SEPARATOR = "_";
    private TemplateImageLoader loader;
    private Hashtable templateImages = new Hashtable();

    public static ImageFactory getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Instance not set up yet");
        }
        return instance;
    }

    public ImageFactory(TemplateImageLoader imageLoader) {
        this.loader = imageLoader;
        instance = this;
    }

    private org.nakedobjects.nos.client.dnd.drawing.Image findIcon(NakedObjectSpecification specification, int iconHeight, Color tint) {
        String className = specification.getFullName().replace('.', '_');
        org.nakedobjects.nos.client.dnd.drawing.Image loadIcon = this.loadIcon(className, iconHeight, tint);
        if (loadIcon == null) {
            loadIcon = this.findIconWithShortName(specification, iconHeight, tint);
        }
        return loadIcon;
    }

    private org.nakedobjects.nos.client.dnd.drawing.Image findIconForSuperClass(NakedObjectSpecification specification, int iconHeight, Color tint) {
        NakedObjectSpecification superclassSpecification = specification.superclass();
        org.nakedobjects.nos.client.dnd.drawing.Image loadIcon = superclassSpecification == null ? null : this.findIcon(superclassSpecification, iconHeight, tint);
        return loadIcon;
    }

    private org.nakedobjects.nos.client.dnd.drawing.Image findIconWithShortName(NakedObjectSpecification specification, int iconHeight, Color tint) {
        String className = specification.getShortName().replace('.', '_');
        org.nakedobjects.nos.client.dnd.drawing.Image loadIcon = this.loadIcon(className, iconHeight, tint);
        if (loadIcon == null) {
            loadIcon = this.findIconForSuperClass(specification, iconHeight, tint);
        }
        return loadIcon;
    }

    public org.nakedobjects.nos.client.dnd.drawing.Image loadDefaultIcon(int height, Color tint) {
        String fallbackImage = NakedObjectsContext.getConfiguration().getString(DEFAULT_IMAGE_PROPERTY, DEFAULT_IMAGE_NAME);
        org.nakedobjects.nos.client.dnd.drawing.Image icon = this.loadIcon(fallbackImage, height, tint);
        if (icon == null) {
            icon = this.loadIcon("unknown", height, tint);
        }
        if (icon == null) {
            throw new NakedObjectRuntimeException("Failed to find default icon: " + fallbackImage);
        }
        return icon;
    }

    public org.nakedobjects.nos.client.dnd.drawing.Image loadIcon(NakedObjectSpecification specification, int iconHeight, Color tint) {
        org.nakedobjects.nos.client.dnd.drawing.Image icon = this.findIcon(specification, iconHeight, null);
        return icon;
    }

    public org.nakedobjects.nos.client.dnd.drawing.Image loadIcon(String name, int height, Color tint) {
        String id = name + SEPARATOR + height + SEPARATOR + tint;
        if (this.templateImages.containsKey(id)) {
            return (org.nakedobjects.nos.client.dnd.drawing.Image)this.templateImages.get(id);
        }
        TemplateImage template = this.templateImage(name);
        if (template == null) {
            return null;
        }
        Image iconImage = template.getIcon(height);
        if (tint != null) {
            Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(iconImage.getSource(), new Filter()));
        }
        AwtImage icon = new AwtImage(iconImage);
        this.templateImages.put(id, icon);
        return icon;
    }

    public org.nakedobjects.nos.client.dnd.drawing.Image loadImage(String path) {
        TemplateImage template = this.templateImage(path);
        if (template == null) {
            return null;
        }
        return new AwtImage(template.getImage());
    }

    private TemplateImage templateImage(String name) {
        TemplateImage template = this.loader.getTemplateImage(name);
        return template;
    }

    private class Filter
    extends RGBImageFilter {
        private Filter() {
        }

        public int filterRGB(int x, int y, int rgb) {
            return 0xFFFFFF - rgb;
        }
    }
}

