/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.lookup;

import org.nakedobjects.nos.client.dnd.KeyboardAction;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.border.AbstractBorder;
import org.nakedobjects.nos.client.dnd.lookup.DropDownAxis;
import org.nakedobjects.nos.client.dnd.lookup.OptionContent;

class DropDownFocusBorder
extends AbstractBorder {
    protected DropDownFocusBorder(View view) {
        super(view);
    }

    public void keyPressed(KeyboardAction key) {
        if (key.getKeyCode() == 40) {
            View[] subviews = this.getSubviews();
            for (int i = 0; i < subviews.length; ++i) {
                if (!subviews[i].getState().isViewIdentified() && i != subviews.length - 1) continue;
                subviews[i].exited();
                subviews[i + 1 >= subviews.length ? 0 : i + 1].entered();
                break;
            }
        } else if (key.getKeyCode() == 38) {
            View[] subviews = this.getSubviews();
            for (int i = 0; i < subviews.length; ++i) {
                if (!subviews[i].getState().isViewIdentified() && i != subviews.length - 1) continue;
                subviews[i].exited();
                subviews[i == 0 ? subviews.length - 1 : i - 1].entered();
                break;
            }
        } else if (key.getKeyCode() == 10) {
            this.selectOption();
        } else if (key.getKeyCode() == 9) {
            this.selectOption();
            DropDownAxis axis = (DropDownAxis)this.getViewAxis();
            View view = axis.getOriginalView();
            View parentView = view.getParent();
            if (key.getModifiers() == 1) {
                parentView.getFocusManager().focusPreviousView();
            } else {
                parentView.getFocusManager().focusNextView();
            }
        }
    }

    private void selectOption() {
        View[] subviews = this.getSubviews();
        for (int i = 0; i < subviews.length; ++i) {
            if (!subviews[i].getState().isViewIdentified()) continue;
            DropDownAxis axis = (DropDownAxis)this.getViewAxis();
            axis.setSelection((OptionContent)subviews[i].getContent());
            View view = axis.getOriginalView();
            View parentView = view.getParent();
            View[] parentsSubviews = parentView.getSubviews();
            int index = 0;
            for (int j = 0; j < parentsSubviews.length; ++j) {
                if (view != parentsSubviews[j]) continue;
                index = j;
                break;
            }
            parentView.updateView();
            parentView.invalidateContent();
            parentView.getFocusManager().setFocus(parentView.getSubviews()[index]);
            this.getView().dispose();
            break;
        }
    }

    public void keyTyped(char keyCode) {
        int j;
        int i;
        View[] subviews = this.getSubviews();
        int old = 0;
        for (i = 0; i < subviews.length; ++i) {
            if (!subviews[i].getState().isViewIdentified()) continue;
            old = i;
            i = i + 1 >= subviews.length ? 0 : i + 1;
            break;
        }
        if (i == subviews.length) {
            i = 0;
        }
        String startsWith = ("" + keyCode).toLowerCase();
        for (j = i; j < subviews.length; ++j) {
            if (!subviews[j].getContent().title().toLowerCase().startsWith(startsWith)) continue;
            subviews[old].exited();
            subviews[j].entered();
            return;
        }
        for (j = 0; j < i; ++j) {
            if (!subviews[j].getContent().title().toLowerCase().startsWith(startsWith)) continue;
            subviews[old].exited();
            subviews[j].entered();
            return;
        }
    }
}

