/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.lookup;

import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.border.AbstractViewDecorator;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.lookup.DropDownAxis;
import org.nakedobjects.nos.client.dnd.lookup.OptionContent;

class DropDownSelection
extends AbstractViewDecorator {
    protected DropDownSelection(View wrappedView) {
        super(wrappedView);
    }

    public void draw(Canvas canvas) {
        if (this.getState().isViewIdentified()) {
            Color color = Toolkit.getColor("secondary3");
            canvas.clearBackground(this, color);
        }
        canvas.offset(HPADDING, 0);
        super.draw(canvas);
    }

    public void entered() {
        this.getState().setContentIdentified();
        this.getState().setViewIdentified();
        this.wrappedView.entered();
        this.markDamaged();
    }

    public void exited() {
        this.getState().clearObjectIdentified();
        this.getState().clearViewIdentified();
        this.wrappedView.exited();
        this.markDamaged();
    }

    public void firstClick(Click click) {
        DropDownAxis axis = (DropDownAxis)this.getViewAxis();
        axis.setSelection((OptionContent)this.getContent());
        View view = axis.getOriginalView();
        view.getParent().updateView();
        view.getParent().invalidateContent();
    }

    public Size getRequiredSize(Size maximumSize) {
        Size size = super.getRequiredSize(maximumSize);
        size.extendWidth(HPADDING * 2);
        return size;
    }
}

