/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.lookup;

import org.nakedobjects.nos.client.dnd.BackgroundTask;
import org.nakedobjects.nos.client.dnd.BackgroundThread;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.KeyboardAction;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.border.AbstractBorder;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Shape;
import org.nakedobjects.nos.client.dnd.drawing.Size;

public abstract class OpenDropDownBorder
extends AbstractBorder {
    private boolean over;

    public OpenDropDownBorder(View wrappedView) {
        super(wrappedView);
        this.right = 18;
    }

    protected abstract View createOverlay();

    public void draw(Canvas canvas) {
        Size size = this.getSize();
        int x = size.getWidth() - this.right + 5 - HPADDING;
        int y = (size.getHeight() - 6) / 2;
        if (this.isAvailable()) {
            Shape triangle = new Shape(0, 0);
            triangle.addVertex(6, 6);
            triangle.addVertex(12, 0);
            canvas.drawShape(triangle, x, y, Toolkit.getColor("secondary2"));
            if (this.over) {
                Color color = this.over ? Toolkit.getColor("secondary1") : Toolkit.getColor("primary2");
                canvas.drawSolidShape(triangle, x, y, color);
            }
        }
        super.draw(canvas);
    }

    public void exited() {
        if (this.over) {
            this.markDamaged();
        }
        this.over = false;
        super.exited();
    }

    public void firstClick(Click click) {
        float boundary;
        float x = click.getLocation().getX() - 2;
        if (x >= (boundary = (float)(this.getSize().getWidth() - this.right))) {
            if (this.isAvailable()) {
                this.open();
            }
        } else {
            super.firstClick(click);
        }
    }

    public Size getRequiredSize(Size maximumSize) {
        maximumSize.contractWidth(HPADDING);
        Size size = super.getRequiredSize(maximumSize);
        size.extendWidth(HPADDING);
        return size;
    }

    protected boolean isAvailable() {
        return true;
    }

    public boolean canFocus() {
        return this.isAvailable();
    }

    public void keyPressed(KeyboardAction key) {
        if (key.getKeyCode() == 40 && this.isAvailable()) {
            this.open();
            key.consume();
        }
        super.keyPressed(key);
    }

    public void mouseMoved(Location at) {
        if (at.getX() >= this.getSize().getWidth() - this.right) {
            this.getFeedbackManager().showDefaultCursor();
            if (!this.over) {
                this.markDamaged();
            }
            this.over = true;
        } else {
            if (this.over) {
                this.markDamaged();
            }
            this.over = false;
            super.mouseMoved(at);
        }
    }

    private void open() {
        BackgroundThread.run(this, new BackgroundTask(){

            public void execute() {
                View overlay = OpenDropDownBorder.this.createOverlay();
                Location location = OpenDropDownBorder.this.getView().getAbsoluteLocation();
                location.add(OpenDropDownBorder.this.getView().getPadding().getLeft() - 1, OpenDropDownBorder.this.getSize().getHeight() + 2);
                overlay.setLocation(location);
                OpenDropDownBorder.this.getViewManager().setOverlayView(overlay);
            }

            public String getDescription() {
                return "";
            }

            public String getName() {
                return "Opening lookup";
            }
        });
    }
}

