/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.notifier;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.content.RootCollection;

public class ViewUpdateNotifier
implements DebugInfo {
    private static final Logger LOG = Logger.getLogger(ViewUpdateNotifier.class);
    protected Hashtable views = new Hashtable();

    public void add(View view) {
        Naked object;
        Content content = view.getContent();
        if (content != null && content.isObject() && (object = content.getNaked()) != null) {
            Vector viewsToNotify;
            if (this.views.containsKey(object)) {
                viewsToNotify = (Vector)this.views.get(object);
            } else {
                viewsToNotify = new Vector();
                this.views.put(object, viewsToNotify);
            }
            if (viewsToNotify.contains(view)) {
                throw new NakedObjectRuntimeException(view + " already being notified");
            }
            viewsToNotify.addElement(view);
            LOG.debug((Object)("added " + view + " to observers for " + object));
        }
    }

    public void debugData(DebugString buf) {
        Enumeration f = this.views.keys();
        while (f.hasMoreElements()) {
            Object object = f.nextElement();
            Vector viewsToNotify = (Vector)this.views.get(object);
            Enumeration e = viewsToNotify.elements();
            buf.append((Object)("Views for " + object + " \n"));
            while (e.hasMoreElements()) {
                View view = (View)e.nextElement();
                buf.append((Object)("        " + view));
                buf.append((Object)"\n");
            }
            buf.append((Object)"\n");
        }
    }

    public String debugTitle() {
        return "Views for object details (observers)";
    }

    public void remove(View view) {
        Content content = view.getContent();
        if (content != null && content.isObject()) {
            LOG.debug((Object)("removing " + content + " for " + view));
            NakedObject object = ((ObjectContent)content).getObject();
            if (object != null) {
                if (this.views.containsKey(object)) {
                    Vector viewsToNotify = (Vector)this.views.get(object);
                    Enumeration e = viewsToNotify.elements();
                    while (e.hasMoreElements()) {
                        View v = (View)e.nextElement();
                        if (view != v.getView()) continue;
                        viewsToNotify.remove(v);
                        LOG.debug((Object)("removed " + view + " from observers for " + object));
                        break;
                    }
                    if (viewsToNotify.size() == 0) {
                        this.views.remove(object);
                        LOG.debug((Object)("removed observer list for " + object));
                    }
                } else {
                    throw new NakedObjectRuntimeException("Tried to remove a non-existant view " + view + " from observers for " + object);
                }
            }
        }
    }

    public void shutdown() {
        this.views.clear();
    }

    public void invalidateViewsForChangedObjects() {
        Enumeration objects = NakedObjectsContext.getUpdateNotifer().allChangedObjects();
        while (objects.hasMoreElements()) {
            NakedObject object = (NakedObject)objects.nextElement();
            LOG.debug((Object)("invalidate views for " + object));
            Object viewsVector = this.views.get(object);
            if (viewsVector == null) continue;
            Enumeration views = ((Vector)viewsVector).elements();
            while (views.hasMoreElements()) {
                View view = (View)views.nextElement();
                LOG.debug((Object)("   - " + view));
                view.getView().invalidateContent();
            }
        }
    }

    public void removeViewsForDisposedObjects() {
        Enumeration objects = NakedObjectsContext.getUpdateNotifer().allDisposedObjects();
        while (objects.hasMoreElements()) {
            NakedObject objectToDispose = (NakedObject)objects.nextElement();
            LOG.debug((Object)("dispose views for " + objectToDispose));
            Vector viewsForObject = (Vector)this.views.get(objectToDispose);
            if (viewsForObject == null) continue;
            this.removeViews(viewsForObject);
            Vector remainingViews = (Vector)this.views.get(objectToDispose);
            if (remainingViews != null && remainingViews.size() > 0) {
                NakedObjectsContext.getMessageBroker().addWarning("There are still views (within other views) for the disposed object " + objectToDispose.titleString() + ".  Only objects that are shown as root views can be properly disposed of");
                continue;
            }
            NakedObjectsContext.getObjectLoader().unloaded(objectToDispose);
        }
    }

    private void removeViews(Vector views) {
        Object[] viewsArray = new View[views.size()];
        views.copyInto(viewsArray);
        View[] viewsOnWorkspace = viewsArray[0].getWorkspace().getSubviews();
        for (int i = 0; i < viewsArray.length; ++i) {
            int j;
            View view = viewsArray[i].getView();
            for (j = 0; j < viewsOnWorkspace.length; ++j) {
                if (view != viewsOnWorkspace[j]) continue;
                LOG.debug((Object)("   (root removed) " + view));
                view.getView().dispose();
                break;
            }
            for (j = 0; j < viewsOnWorkspace.length; ++j) {
                if (!(viewsOnWorkspace[j].getContent() instanceof RootCollection)) continue;
                View[] subviewsOfRootView = viewsOnWorkspace[j].getSubviews();
                for (int k = 0; k < subviewsOfRootView.length; ++k) {
                    if (subviewsOfRootView[k] != view) continue;
                    LOG.debug((Object)("   (element removed) " + view));
                    view.getView().dispose();
                }
            }
            for (j = 0; j < viewsOnWorkspace.length; ++j) {
                if (!viewsOnWorkspace[j].contains(view)) continue;
                LOG.debug((Object)("   (invalidated) " + view));
                View parent = view.getParent();
                parent.invalidateContent();
            }
        }
    }
}

