/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.table;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.value.ImageValue;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.OneToManyAssociation;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nos.client.dnd.CollectionContent;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.SubviewSpec;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.builder.AbstractCompositeViewSpecification;
import org.nakedobjects.nos.client.dnd.builder.CollectionElementBuilder;
import org.nakedobjects.nos.client.dnd.builder.StackLayout;
import org.nakedobjects.nos.client.dnd.table.TableAxis;
import org.nakedobjects.nos.client.dnd.table.TableRowSpecification;
import org.nakedobjects.nos.client.dnd.table.TypeBasedColumnWidthStrategy;

public abstract class AbstractTableSpecification
extends AbstractCompositeViewSpecification
implements SubviewSpec {
    private static final Logger LOG = Logger.getLogger(AbstractTableSpecification.class);
    private ViewSpecification rowSpecification;

    public AbstractTableSpecification() {
        this.builder = new StackLayout(new CollectionElementBuilder(this));
    }

    public boolean canDisplay(Content content) {
        if (content.isCollection()) {
            NakedCollection coll = ((CollectionContent)((Object)content)).getCollection();
            NakedObjectSpecification elementSpecification = coll.getElementSpecification();
            NakedObjectField[] fields = elementSpecification.getStaticallyVisibleFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].isObject() && !fields[i].isValue()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public View createSubview(Content content, ViewAxis axis) {
        return this.rowSpecification.createView(content, axis);
    }

    public final View createView(Content content, ViewAxis axis) {
        NakedCollection coll = ((CollectionContent)((Object)content)).getCollection();
        NakedObjectSpecification elementSpecification = coll.getElementSpecification();
        NakedObjectField[] accessibleFields = elementSpecification.getStaticallyVisibleFields();
        TableAxis tableAxis = new TableAxis(this.tableFields(accessibleFields));
        tableAxis.setupColumnWidths(new TypeBasedColumnWidthStrategy());
        View table = super.createView(content, tableAxis);
        tableAxis.setRoot(table);
        this.rowSpecification = new TableRowSpecification();
        return this.doCreateView(table, content, axis);
    }

    protected abstract View doCreateView(View var1, Content var2, ViewAxis var3);

    public String getName() {
        return "Standard Table";
    }

    public boolean isReplaceable() {
        return false;
    }

    private NakedObjectField[] tableFields(NakedObjectField[] viewFields) {
        for (int i = 0; i < viewFields.length; ++i) {
            if (viewFields[i].getSpecification().isOfType(NakedObjectsContext.getReflector().loadSpecification(ImageValue.class)) || !viewFields[i].isVisible()) continue;
            LOG.debug((Object)("column " + viewFields[i].getSpecification()));
        }
        NakedObjectField[] tableFields = new NakedObjectField[viewFields.length];
        int c = 0;
        for (int i = 0; i < viewFields.length; ++i) {
            if (viewFields[i] instanceof OneToManyAssociation) continue;
            tableFields[c++] = viewFields[i];
        }
        NakedObjectField[] results = new NakedObjectField[c];
        System.arraycopy(tableFields, 0, results, 0, c);
        return results;
    }
}

