/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.table;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.adapter.value.ImageValue;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.OneToManyAssociation;
import org.nakedobjects.noa.reflect.OneToOneAssociation;
import org.nakedobjects.noa.reflect.ValueAssociation;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nof.core.util.UnexpectedCallException;
import org.nakedobjects.nof.core.util.UnknownTypeException;
import org.nakedobjects.nos.client.dnd.CompositeViewSpecification;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.ValueContent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewFactory;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.basic.UnlinedTextFieldSpecification;
import org.nakedobjects.nos.client.dnd.builder.AbstractViewBuilder;
import org.nakedobjects.nos.client.dnd.content.AbstractContent;
import org.nakedobjects.nos.client.dnd.content.OneToOneFieldImpl;
import org.nakedobjects.nos.client.dnd.content.ValueFieldImpl;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Padding;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.table.TableAxis;
import org.nakedobjects.nos.client.dnd.view.simple.BlankView;
import org.nakedobjects.nos.client.dnd.view.simple.CompositeView;
import org.nakedobjects.nos.client.dnd.view.simple.FieldErrorView;

class TableCellBuilder
extends AbstractViewBuilder {
    private static final Logger LOG = Logger.getLogger(TableCellBuilder.class);

    TableCellBuilder() {
    }

    private void addField(View view, NakedObject object, NakedObjectField field) {
        Naked value = field.get(object);
        View fieldView = this.createFieldView(view, object, field, value);
        if (fieldView != null) {
            view.addView(this.decorateSubview(fieldView));
        } else {
            view.addView(new FieldErrorView("No field for " + value));
        }
    }

    public void build(View view) {
        Assert.assertEquals((String)"ensure the view is complete decorated view", (Object)view.getView(), (Object)view);
        Content content = view.getContent();
        NakedObject object = ((ObjectContent)content).getObject();
        TableAxis viewAxis = (TableAxis)view.getViewAxis();
        if (view.getSubviews().length == 0) {
            this.buildNew(object, view, viewAxis);
        } else {
            this.buildUpdate(object, view, viewAxis);
        }
    }

    private void buildUpdate(NakedObject object, View view, TableAxis viewAxis) {
        LOG.debug((Object)("update view " + view + " for " + object));
        View[] subviews = view.getSubviews();
        NakedObjectSpecification spec = object.getSpecification();
        for (int i = 0; i < subviews.length; ++i) {
            boolean changedValue;
            NakedObjectField field = this.fieldFromActualSpec(spec, viewAxis.getFieldForColumn(i));
            View subview = subviews[i];
            Naked value = field.get(object);
            if (field.isValue()) {
                boolean valueChange;
                boolean visiblityChange = !field.isVisible((NakedReference)object) ^ subview instanceof BlankView;
                Naked naked = subview.getContent().getNaked();
                boolean bl = valueChange = value != null && value.getObject() != null && !value.getObject().equals(naked.getObject());
                if (visiblityChange || valueChange) {
                    View fieldView = this.createFieldView(view, object, field, value);
                    view.replaceView(subview, this.decorateSubview(fieldView));
                }
                subview.refresh();
                continue;
            }
            if (!field.isObject()) continue;
            NakedObject existing = ((ObjectContent)subviews[i].getContent()).getObject();
            boolean bl = changedValue = value != existing;
            if (!changedValue) continue;
            View fieldView = this.createFieldView(view, object, field, value);
            if (fieldView != null) {
                view.replaceView(subview, this.decorateSubview(fieldView));
                continue;
            }
            view.addView(new FieldErrorView("No field for " + value));
        }
    }

    private NakedObjectField fieldFromActualSpec(NakedObjectSpecification spec, NakedObjectField field) {
        String fieldName = field.getId();
        return spec.getField(fieldName);
    }

    private void buildNew(NakedObject object, View view, TableAxis viewAxis) {
        LOG.debug((Object)("build view " + view + " for " + object));
        int len = viewAxis.getColumnCount();
        NakedObjectSpecification spec = object.getSpecification();
        for (int f = 0; f < len; ++f) {
            NakedObjectField field = this.fieldFromActualSpec(spec, viewAxis.getFieldForColumn(f));
            this.addField(view, object, field);
        }
    }

    public View createCompositeView(Content content, CompositeViewSpecification specification, ViewAxis axis) {
        return new CompositeView(content, specification, axis);
    }

    private View createFieldView(View view, NakedObject object, NakedObjectField field, Naked value) {
        ViewSpecification cellSpec;
        AbstractContent content;
        if (field == null) {
            throw new NullPointerException();
        }
        ViewFactory factory = Toolkit.getViewFactory();
        if (field instanceof OneToManyAssociation) {
            throw new UnexpectedCallException("no collections allowed");
        }
        if (field.isValue()) {
            content = new ValueFieldImpl(object, (NakedValue)value, (ValueAssociation)field);
            if (content.getNaked() instanceof ImageValue) {
                return new BlankView(content);
            }
            if (!field.isVisible((NakedReference)object)) {
                return new BlankView(content);
            }
            cellSpec = ((ValueContent)((Object)content)).getNoLines() > 0 ? new UnlinedTextFieldSpecification() : factory.getValueFieldSpecification((ValueContent)((Object)content));
        } else if (field instanceof OneToOneAssociation) {
            content = new OneToOneFieldImpl(object, (NakedObject)value, (OneToOneAssociation)field);
            if (!field.isVisible((NakedReference)object)) {
                return new BlankView(content);
            }
            cellSpec = factory.getIconizedSubViewSpecification((ObjectContent)((Object)content));
        } else {
            throw new UnknownTypeException((Object)field);
        }
        ViewAxis axis = view.getViewAxis();
        return cellSpec.createView(content, axis);
    }

    public Size getRequiredSize(View row) {
        int maxHeight = 0;
        int totalWidth = 0;
        TableAxis axis = (TableAxis)row.getViewAxis();
        View[] cells = row.getSubviews();
        int maxBaseline = this.maxBaseline(cells);
        for (int i = 0; i < cells.length; ++i) {
            totalWidth += axis.getColumnWidth(i);
            Size s = cells[i].getRequiredSize(new Size());
            int b = cells[i].getBaseline();
            int baselineOffset = Math.max(0, maxBaseline - b);
            maxHeight = Math.max(maxHeight, s.getHeight() + baselineOffset);
        }
        return new Size(totalWidth, maxHeight);
    }

    public void layout(View row, Size maximumSize) {
        int x = 0;
        TableAxis axis = (TableAxis)row.getViewAxis();
        View[] cells = row.getSubviews();
        int maxBaseline = this.maxBaseline(cells);
        for (int i = 0; i < cells.length; ++i) {
            View cell = cells[i];
            Size s = cell.getRequiredSize(new Size(maximumSize));
            s.setWidth(axis.getColumnWidth(i));
            cell.setSize(s);
            int b = cell.getBaseline();
            int baselineOffset = Math.max(0, maxBaseline - b);
            cell.setLocation(new Location(x, baselineOffset));
            x += s.getWidth();
        }
        Padding padding = row.getPadding();
        Size size = new Size(padding.getLeftRight(), padding.getTopBottom());
        row.setSize(size);
    }

    private int maxBaseline(View[] cells) {
        int maxBaseline = 0;
        for (int i = 0; i < cells.length; ++i) {
            View cell = cells[i];
            maxBaseline = Math.max(maxBaseline, cell.getBaseline());
        }
        return maxBaseline;
    }
}

