/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.table;

import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.ContentDrag;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.ViewDrag;
import org.nakedobjects.nos.client.dnd.border.AbstractBorder;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Offset;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.table.TableAxis;
import org.nakedobjects.nos.client.dnd.view.graphic.IconGraphic;
import org.nakedobjects.nos.client.dnd.view.simple.DragViewOutline;
import org.nakedobjects.nos.client.dnd.view.text.ObjectTitleText;
import org.nakedobjects.nos.client.dnd.view.text.TitleText;

public class TableRowBorder
extends AbstractBorder {
    private static final int BORDER = 13;
    private int baseline;
    private IconGraphic icon = new IconGraphic((View)this, Toolkit.getText("normal"));
    private TitleText title = new ObjectTitleText(this, Toolkit.getText("normal"));

    public TableRowBorder(View wrappedRow) {
        super(wrappedRow);
        this.baseline = this.icon.getBaseline();
        this.left = this.requiredTitleWidth() + 13;
        ((TableAxis)wrappedRow.getViewAxis()).ensureOffset(this.left);
    }

    public void debugDetails(DebugString debug) {
        debug.append((Object)("RowBorder " + this.left + " pixels"));
    }

    public Drag dragStart(DragStart drag) {
        TableAxis axis;
        int left;
        int x = drag.getLocation().getX();
        if (x < (left = (axis = (TableAxis)this.getViewAxis()).getHeaderOffset()) - 13) {
            View dragOverlay = Toolkit.getViewFactory().getContentDragSpecification().createView(this.getContent(), null);
            return new ContentDrag(this, drag.getLocation(), dragOverlay);
        }
        if (x < left) {
            DragViewOutline dragOverlay = new DragViewOutline(this.getView());
            return new ViewDrag(this, new Offset(drag.getLocation()), dragOverlay);
        }
        return super.dragStart(drag);
    }

    public void draw(Canvas canvas) {
        int baseline = this.getBaseline();
        TableAxis axis = (TableAxis)this.getViewAxis();
        int width = axis.getHeaderOffset();
        Size s = this.getSize();
        Canvas subcanvas = canvas.createSubcanvas(0, 0, width, s.getHeight());
        int offset = HPADDING;
        this.icon.draw(subcanvas, offset, baseline);
        this.title.draw(subcanvas, offset += this.icon.getSize().getWidth() + HPADDING + 0 + HPADDING, baseline, this.getLeft() - offset);
        int columns = axis.getColumnCount();
        int x = -1;
        canvas.drawLine((x += axis.getHeaderOffset()) - 1, 0, x - 1, s.getHeight() - 1, Toolkit.getColor("secondary1"));
        canvas.drawLine(x, 0, x, s.getHeight() - 1, Toolkit.getColor("secondary1"));
        for (int i = 0; i < columns; ++i) {
            canvas.drawLine(x += axis.getColumnWidth(i), 0, x, s.getHeight() - 1, Toolkit.getColor("secondary1"));
        }
        int y = s.getHeight() - 1;
        canvas.drawLine(0, y, s.getWidth(), y, Toolkit.getColor("secondary2"));
        if (this.getState().isObjectIdentified()) {
            int xExtent = width - 1;
            canvas.drawLine(xExtent - 13, this.top, xExtent - 13, this.top + s.getHeight() - 1, Toolkit.getColor("secondary2"));
            canvas.drawSolidRectangle(xExtent - 13 + 1, this.top, 11, s.getHeight() - 2 * this.top - 1, Toolkit.getColor("secondary3"));
        }
        super.draw(canvas);
    }

    public int getBaseline() {
        return this.baseline;
    }

    protected int getLeft() {
        return ((TableAxis)this.wrappedView.getViewAxis()).getHeaderOffset();
    }

    protected int requiredTitleWidth() {
        return HPADDING + this.icon.getSize().getWidth() + HPADDING + this.title.getSize().getWidth() + HPADDING;
    }

    public void entered() {
        this.getState().setContentIdentified();
        this.getState().setViewIdentified();
        this.wrappedView.entered();
        this.markDamaged();
    }

    public void exited() {
        this.getState().clearObjectIdentified();
        this.getState().clearViewIdentified();
        this.wrappedView.exited();
        this.markDamaged();
    }

    public void secondClick(Click click) {
        TableAxis axis = (TableAxis)this.getViewAxis();
        int left = axis.getHeaderOffset();
        int x = click.getLocation().getX();
        if (x <= left) {
            Location location = this.getAbsoluteLocation();
            location.translate(click.getLocation());
            View openWindow = Toolkit.getViewFactory().createWindow(this.getContent());
            openWindow.setLocation(location);
            this.getWorkspace().addView(openWindow);
        } else {
            super.secondClick(click);
        }
    }

    public String toString() {
        return this.wrappedView.toString() + "/RowBorder";
    }

    public ViewAreaType viewAreaType(Location mouseLocation) {
        if (mouseLocation.getX() <= this.left) {
            return ViewAreaType.CONTENT;
        }
        if (mouseLocation.getX() >= this.getSize().getWidth() - this.right) {
            return ViewAreaType.VIEW;
        }
        return super.viewAreaType(mouseLocation);
    }
}

