/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.tree;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.Features;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.tree.LeafNodeView;
import org.nakedobjects.nos.client.dnd.tree.NodeSpecification;

class ClosedObjectNodeSpecification
extends NodeSpecification {
    private final boolean showObjectContents;

    public ClosedObjectNodeSpecification(boolean showObjectContents) {
        this.showObjectContents = showObjectContents;
    }

    public boolean canDisplay(Content content) {
        return content.isObject() && content.getNaked() != null;
    }

    public int canOpen(Content content) {
        NakedObject object = ((ObjectContent)content).getObject();
        NakedObjectField[] fields = object.getSpecification().getDynamicallyVisibleFields(object);
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].isCollection()) {
                return 1;
            }
            if (!this.showObjectContents || !fields[i].isObject() || Features.isBoundedSet((NakedObjectSpecification)object.getSpecification())) continue;
            return 1;
        }
        return 2;
    }

    protected View createNodeView(Content content, ViewAxis axis) {
        LeafNodeView treeLeafNode = new LeafNodeView(content, this, axis);
        return treeLeafNode;
    }

    public String getName() {
        return "Object tree node - closed";
    }
}

