/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.tree;

import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.border.WindowBorder;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.tree.ClosedCollectionNodeSpecification;
import org.nakedobjects.nos.client.dnd.tree.ClosedObjectNodeSpecification;
import org.nakedobjects.nos.client.dnd.tree.OpenCollectionNodeSpecification;
import org.nakedobjects.nos.client.dnd.tree.OpenObjectNodeSpecification;
import org.nakedobjects.nos.client.dnd.tree.TreeBrowserFrame;

public class FullTreeBrowserSpecification
implements ViewSpecification {
    private final OpenCollectionNodeSpecification openCollection;
    private final OpenObjectNodeSpecification openObject;

    public FullTreeBrowserSpecification() {
        ClosedObjectNodeSpecification closedObject = new ClosedObjectNodeSpecification(true);
        ClosedCollectionNodeSpecification closedCollection = new ClosedCollectionNodeSpecification();
        this.openObject = new OpenObjectNodeSpecification();
        this.openObject.setCollectionSubNodeSpecification(closedCollection);
        this.openObject.setObjectSubNodeSpecification(closedObject);
        this.openObject.setReplacementNodeSpecification(closedObject);
        closedObject.setReplacementNodeSpecification(this.openObject);
        this.openCollection = new OpenCollectionNodeSpecification();
        this.openCollection.setCollectionSubNodeSpecification(closedCollection);
        this.openCollection.setObjectSubNodeSpecification(closedObject);
        this.openCollection.setReplacementNodeSpecification(closedCollection);
        closedCollection.setReplacementNodeSpecification(this.openCollection);
    }

    public boolean canDisplay(Content content) {
        return this.openCollection.canDisplay(content) || this.openObject.canDisplay(content);
    }

    public View createView(Content content, ViewAxis unused) {
        View rootNode;
        TreeBrowserFrame frame = new TreeBrowserFrame(content, this);
        View view = this.addBorder(frame);
        TreeBrowserFrame axis = frame;
        if (this.openCollection.canDisplay(content)) {
            rootNode = this.openCollection.createView(content, axis);
        } else {
            rootNode = this.openObject.createView(content, axis);
            frame.setSelectedNode(rootNode);
        }
        View leftPane = rootNode;
        frame.initLeftPane(leftPane);
        Size size = leftPane.getRequiredSize(new Size());
        size.setWidth(220);
        leftPane.setMaximumSize(size);
        return view;
    }

    protected View addBorder(View frame) {
        return new WindowBorder(frame, false);
    }

    public String getName() {
        return "Long Tree Browser";
    }

    public boolean isAligned() {
        return false;
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isReplaceable() {
        return true;
    }

    public boolean isSubView() {
        return false;
    }
}

