/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.tree;

import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.FocusManager;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.border.ScrollBorder;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Padding;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.tree.InternalTableSpecification;
import org.nakedobjects.nos.client.dnd.tree.SimpleListSpecification;
import org.nakedobjects.nos.client.dnd.tree.TreeBrowserResizeBorder;
import org.nakedobjects.nos.client.dnd.view.form.InternalFormSpecification;
import org.nakedobjects.nos.client.dnd.view.simple.AbstractView;

public class TreeBrowserFrame
extends AbstractView
implements ViewAxis {
    private ViewSpecification mainViewFormSpec = new InternalFormSpecification();
    private ViewSpecification mainViewListSpec;
    private ViewSpecification mainViewTableSpec = new InternalTableSpecification();
    private boolean invalidLayout = true;
    private int layoutCount = 0;
    private View left;
    private View right;
    private View selectedNode;
    private FocusManager focusManager;

    public TreeBrowserFrame(Content content, ViewSpecification specification) {
        super(content, specification, null);
        this.mainViewListSpec = new SimpleListSpecification();
    }

    public void debug(DebugString debug) {
        super.debug(debug);
        debug.append((Object)("\nLaid out:  " + (this.invalidLayout ? "no" : "yes") + ", " + this.layoutCount + " layouts"));
        debug.append((Object)"\nBrowser:   ");
        debug.append((Object)this);
        debug.append((Object)"\n           left: ");
        debug.append((Object)this.left.getBounds());
        debug.append((Object)" ");
        debug.append((Object)this.left);
        debug.append((Object)": ");
        debug.append((Object)this.left.getContent());
        debug.append((Object)"\n           right: ");
        if (this.right == null) {
            debug.append((Object)"nothing");
        } else {
            debug.append((Object)this.right.getBounds());
            debug.append((Object)" ");
            debug.append((Object)this.right);
            debug.append((Object)": ");
            debug.append((Object)this.right.getContent());
        }
        debug.append((Object)"\n\n");
    }

    public void dispose() {
        this.left.dispose();
        if (this.right != null) {
            this.right.dispose();
        }
        super.dispose();
    }

    public void invalidateContent() {
        if (this.left != null) {
            this.left.invalidateContent();
        }
        if (this.right != null) {
            this.right.invalidateContent();
        }
        super.invalidateContent();
    }

    public void draw(Canvas canvas) {
        Bounds bounds = this.left.getBounds();
        Canvas subCanvas = canvas.createSubcanvas(bounds);
        Color leftBackground = Toolkit.getColor("background.window." + this.getSpecification().getName() + ".left");
        if (leftBackground != Toolkit.getColor("background.window")) {
            subCanvas.clearBackground(this.left, leftBackground);
        }
        this.left.draw(subCanvas);
        if (this.right != null) {
            bounds = this.right.getBounds();
            subCanvas = canvas.createSubcanvas(bounds);
            Color rightBackground = Toolkit.getColor("background.window." + this.getSpecification().getName() + ".right");
            if (rightBackground != Toolkit.getColor("background.window")) {
                subCanvas.clearBackground(this.right, rightBackground);
            }
            this.right.draw(subCanvas);
        }
        canvas.drawLine(0, bounds.getHeight() - 1, this.getSize().getWidth(), bounds.getHeight() - 1, Toolkit.getColor("secondary1"));
    }

    public FocusManager getFocusManager() {
        return this.focusManager;
    }

    public Size getMaximumSize() {
        Size leftMaximumSize = this.left == null ? new Size() : this.left.getMaximumSize();
        Size rightMaximumSize = this.right == null ? new Size() : this.right.getMaximumSize();
        Size total = new Size(leftMaximumSize);
        total.extendWidth(rightMaximumSize.getWidth());
        total.ensureHeight(rightMaximumSize.getHeight());
        return total;
    }

    public Size getRequiredSize(Size maximumSize) {
        Size rightPanelRequiredSize;
        Size leftPanelRequiredSize = this.left.getRequiredSize(new Size(maximumSize));
        Size size = rightPanelRequiredSize = this.right == null ? new Size() : this.right.getRequiredSize(new Size(maximumSize));
        if (leftPanelRequiredSize.getWidth() + rightPanelRequiredSize.getWidth() > maximumSize.getWidth()) {
            int availableWidth = maximumSize.getWidth();
            int leftWidth = leftPanelRequiredSize.getWidth();
            int rightWidth = rightPanelRequiredSize.getWidth();
            int totalWidth = leftWidth + rightWidth;
            int bestWidth = (int)(1.0 * (double)leftWidth / (double)totalWidth * (double)availableWidth);
            Size maximumSizeLeft = new Size(bestWidth, maximumSize.getHeight());
            leftPanelRequiredSize = this.left.getRequiredSize(maximumSizeLeft);
            Size maximumSizeRight = new Size(availableWidth - leftPanelRequiredSize.getWidth(), maximumSize.getHeight());
            rightPanelRequiredSize = this.right.getRequiredSize(maximumSizeRight);
        }
        Size combinedSize = new Size(leftPanelRequiredSize);
        combinedSize.extendWidth(rightPanelRequiredSize.getWidth());
        combinedSize.ensureHeight(rightPanelRequiredSize.getHeight());
        return combinedSize;
    }

    public View getSelectedNode() {
        return this.selectedNode;
    }

    public View[] getSubviews() {
        View[] viewArray;
        if (this.right == null) {
            View[] viewArray2 = new View[1];
            viewArray = viewArray2;
            viewArray2[0] = this.left;
        } else {
            View[] viewArray3 = new View[2];
            viewArray3[0] = this.left;
            viewArray = viewArray3;
            viewArray3[1] = this.right;
        }
        return viewArray;
    }

    public void invalidateLayout() {
        super.invalidateLayout();
        this.invalidLayout = true;
    }

    public void layout(Size maximumSize) {
        if (this.invalidLayout) {
            Size rightPanelRequiredSize;
            maximumSize.contract(this.getView().getPadding());
            Size leftPanelRequiredSize = this.left.getRequiredSize(new Size(maximumSize));
            Size size = rightPanelRequiredSize = this.right == null ? new Size() : this.right.getRequiredSize(new Size(maximumSize));
            if (leftPanelRequiredSize.getWidth() + rightPanelRequiredSize.getWidth() > maximumSize.getWidth()) {
                int availableWidth = maximumSize.getWidth();
                int leftWidth = leftPanelRequiredSize.getWidth();
                int rightWidth = rightPanelRequiredSize.getWidth();
                int totalWidth = leftWidth + rightWidth;
                int bestWidth = (int)(1.0 * (double)leftWidth / (double)totalWidth * (double)availableWidth);
                Size maximumSizeLeft = new Size(bestWidth, maximumSize.getHeight());
                leftPanelRequiredSize = this.left.getRequiredSize(maximumSizeLeft);
                Size maximumSizeRight = new Size(availableWidth - leftPanelRequiredSize.getWidth(), maximumSize.getHeight());
                rightPanelRequiredSize = this.right.getRequiredSize(maximumSizeRight);
            }
            Size combinedSize = new Size(leftPanelRequiredSize);
            combinedSize.extendWidth(rightPanelRequiredSize.getWidth());
            combinedSize.ensureHeight(rightPanelRequiredSize.getHeight());
            combinedSize.setHeight(Math.min(combinedSize.getHeight(), maximumSize.getHeight()));
            this.left.setSize(new Size(leftPanelRequiredSize.getWidth(), combinedSize.getHeight()));
            this.left.layout(new Size(new Size(leftPanelRequiredSize)));
            if (this.right != null) {
                this.right.setLocation(new Location(this.left.getSize().getWidth(), 0));
                rightPanelRequiredSize.setHeight(combinedSize.getHeight());
                this.right.setSize(rightPanelRequiredSize);
                this.right.layout(rightPanelRequiredSize);
            }
            ++this.layoutCount;
            this.invalidLayout = false;
        }
    }

    public View subviewFor(Location location) {
        Location l = new Location(location);
        Padding padding = this.getPadding();
        l.subtract(padding.getLeft(), padding.getTop());
        if (this.left.getBounds().contains(location)) {
            return this.left;
        }
        if (this.right != null && this.right.getBounds().contains(location)) {
            return this.right;
        }
        return null;
    }

    public void replaceView(View toReplace, View replacement) {
        if (toReplace == this.left) {
            this.initLeftPane(replacement);
            this.invalidateLayout();
        } else if (toReplace == this.right) {
            this.showInRightPane(replacement);
        } else {
            throw new NakedObjectRuntimeException();
        }
    }

    public void removeView(View view) {
        if (view == this.left) {
            this.left = null;
        } else if (view == this.right) {
            this.right = null;
        }
    }

    void initLeftPane(View view) {
        this.left = new TreeBrowserResizeBorder(new ScrollBorder(view));
        this.left.setParent(this.getView());
    }

    protected void showInRightPane(View view) {
        this.right = view;
        this.right.setParent(this.getView());
        this.invalidateLayout();
    }

    public void setFocusManager(FocusManager focusManager) {
        this.focusManager = focusManager;
    }

    public void setSelectedNode(View view) {
        Content content = view.getContent();
        Naked object = content.getNaked();
        NakedObjectSpecification specification = object.getSpecification();
        if (specification.getType() == 274) {
            if (object != null && this.mainViewFormSpec.canDisplay(content)) {
                this.selectedNode = view;
                this.showInRightPane(this.mainViewFormSpec.createView(content, null));
            }
        } else if (specification.getType() == 275 && ((NakedCollection)object).size() > 0) {
            if (this.mainViewTableSpec.canDisplay(content)) {
                this.selectedNode = view;
                this.showInRightPane(this.mainViewTableSpec.createView(content, null));
            } else if (this.mainViewListSpec.canDisplay(content)) {
                this.selectedNode = view;
                this.showInRightPane(this.mainViewListSpec.createView(content, null));
            }
        }
    }

    public String toString() {
        return "TreeBrowserFrame" + this.getId();
    }
}

