/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.tree;

import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.basic.ResizeBorder;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.DrawingUtil;
import org.nakedobjects.nos.client.dnd.drawing.Size;

public class TreeBrowserResizeBorder
extends ResizeBorder {
    public static final int BORDER_WIDTH = NakedObjectsContext.getConfiguration().getInteger("nakedobjects.viewer.dnd.tree-resize-border", 7);

    public TreeBrowserResizeBorder(View view) {
        super(view, 2, BORDER_WIDTH, 2);
    }

    protected void drawResizeBorder(Canvas canvas, Size size) {
        int h2;
        int h1;
        int x = this.getSize().getWidth() - BORDER_WIDTH;
        int height = this.getSize().getHeight() - 1;
        if (height < (h1 = 30) + (h2 = 10) * 2) {
            h1 = Math.min(0, height - h2 * 2);
        } else {
            h2 = (height - h1) / 2;
        }
        boolean hasFocus = this.getParent().containsFocus();
        Color borderColor = hasFocus ? Toolkit.getColor("primary3") : Toolkit.getColor("secondary3");
        canvas.drawSolidRectangle(x, 0, BORDER_WIDTH, height, borderColor);
        canvas.drawRectangle(x, -1, BORDER_WIDTH, height + 2, Toolkit.getColor("secondary2"));
        Color color = hasFocus ? Toolkit.getColor("primary2") : Toolkit.getColor("secondary2");
        DrawingUtil.drawHatching(canvas, x + 1, h2, BORDER_WIDTH - 2, h1, color, Toolkit.getColor("white"));
    }
}

