/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.tree;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.OneToManyAssociation;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.CollectionContent;
import org.nakedobjects.nos.client.dnd.ContentDrag;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.FieldContent;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.OneToManyField;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.ViewDrag;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.border.AbstractBorder;
import org.nakedobjects.nos.client.dnd.content.CollectionElement;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Offset;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.drawing.Text;
import org.nakedobjects.nos.client.dnd.tree.NodeSpecification;
import org.nakedobjects.nos.client.dnd.tree.TreeBrowserFrame;
import org.nakedobjects.nos.client.dnd.tree.TreeDisplayRules;
import org.nakedobjects.nos.client.dnd.view.graphic.IconGraphic;
import org.nakedobjects.nos.client.dnd.view.simple.DragViewOutline;
import org.nakedobjects.nos.client.dnd.view.text.ObjectTitleText;
import org.nakedobjects.nos.client.dnd.view.text.TitleText;

public class TreeNodeBorder
extends AbstractBorder {
    private static final int BORDER = 13;
    private static final int BOX_PADDING = 2;
    private static final int BOX_SIZE = 9;
    private static final int BOX_X_OFFSET = 5;
    private static final Text LABEL_STYLE = Toolkit.getText("normal");
    private static final Logger LOG = Logger.getLogger(TreeNodeBorder.class);
    private int baseline;
    private IconGraphic icon;
    private ViewSpecification replaceWithSpecification;
    private TitleText text;

    public TreeNodeBorder(View wrappedView, ViewSpecification replaceWith) {
        super(wrappedView);
        this.replaceWithSpecification = replaceWith;
        this.icon = new IconGraphic((View)this, LABEL_STYLE);
        this.text = new ObjectTitleText(this, LABEL_STYLE);
        int height = this.icon.getSize().getHeight();
        this.baseline = this.icon.getBaseline() + 1;
        this.left = 22;
        this.right = 13;
        this.top = height + 2;
        this.bottom = 0;
    }

    private int canOpen() {
        return ((NodeSpecification)this.getSpecification()).canOpen(this.getContent());
    }

    protected Bounds contentArea() {
        return new Bounds(this.getLeft(), this.getTop(), this.wrappedView.getSize().getWidth(), this.wrappedView.getSize().getHeight());
    }

    public void debugDetails(DebugString debug) {
        debug.append((Object)("TreeNodeBorder " + this.left + " pixels\n"));
        debug.append((Object)("           titlebar " + this.top + " pixels\n"));
        debug.append((Object)("           replace with  " + this.replaceWithSpecification));
        debug.append((Object)("           text " + this.text));
        debug.append((Object)("           icon " + this.icon));
        super.debugDetails(debug);
    }

    public Drag dragStart(DragStart drag) {
        if (drag.getLocation().getX() > this.getSize().getWidth() - this.right) {
            DragViewOutline dragOverlay = new DragViewOutline(this.getView());
            return new ViewDrag(this, new Offset(drag.getLocation()), dragOverlay);
        }
        if (this.overBorder(drag.getLocation())) {
            View dragOverlay = Toolkit.getViewFactory().getContentDragSpecification().createView(this.getContent(), null);
            return new ContentDrag(this, drag.getLocation(), dragOverlay);
        }
        return super.dragStart(drag);
    }

    public void draw(Canvas canvas) {
        View[] nodes;
        boolean addBox;
        Color color = Toolkit.getColor("secondary2");
        if (((TreeBrowserFrame)this.getViewAxis()).getSelectedNode() == this.getView()) {
            canvas.drawSolidRectangle(this.left, 0, this.getSize().getWidth() - this.left, this.top, Toolkit.getColor("primary2"));
            color = Toolkit.getColor("secondary1");
        }
        if (this.getState().isObjectIdentified()) {
            canvas.drawRectangle(this.left, 0, this.getSize().getWidth() - this.left, this.top, color);
            int xExtent = this.getSize().getWidth();
            canvas.drawSolidRectangle(xExtent - 13 + 1, 1, 11, this.top - 2, Toolkit.getColor("secondary3"));
            canvas.drawLine(xExtent - 13, 0, xExtent - 13, this.top - 2, color);
        }
        int x = 0;
        int y = this.top / 2;
        canvas.drawLine(x, y, x + this.left, y, Toolkit.getColor("secondary2"));
        boolean isOpen = this.getSpecification().isOpen();
        int canOpen = this.canOpen();
        boolean bl = addBox = isOpen || canOpen != 2;
        if (addBox) {
            canvas.drawLine(x += 5, y, x + 9 - 1, y, Toolkit.getColor("secondary3"));
            canvas.drawSolidRectangle(x, y - 4, 9, 9, Toolkit.getColor("white"));
            canvas.drawRectangle(x, y - 4, 9, 9, Toolkit.getColor("secondary1"));
            if (canOpen != 0) {
                canvas.drawLine(x + 2, y, x + 9 - 1 - 2, y, Toolkit.getColor("black"));
                if (!isOpen) {
                    canvas.drawLine(x += 4, y - 4 + 2, x, y + 4 - 2, Toolkit.getColor("black"));
                }
            }
        }
        if ((nodes = this.getSubviews()).length > 0) {
            int y1 = this.top / 2;
            View node = nodes[nodes.length - 1];
            int y2 = this.top + node.getLocation().getY() + this.top / 2;
            canvas.drawLine(this.left - 1, y1, this.left - 1, y2, Toolkit.getColor("secondary2"));
        }
        x = this.left + 1;
        this.icon.draw(canvas, x, this.baseline);
        this.text.draw(canvas, x += this.icon.getSize().getWidth(), this.baseline);
        if (Toolkit.debug) {
            canvas.drawRectangleAround(this, Toolkit.getColor("debug.baseline"));
        }
        super.draw(canvas);
    }

    public void entered() {
        this.getState().setContentIdentified();
        this.getState().setViewIdentified();
        this.wrappedView.entered();
        this.markDamaged();
    }

    public void exited() {
        this.getState().clearObjectIdentified();
        this.getState().clearViewIdentified();
        this.wrappedView.exited();
        this.markDamaged();
    }

    public void firstClick(Click click) {
        int y;
        int x = click.getLocation().getX();
        if (this.withinBox(x, y = click.getLocation().getY())) {
            if (this.canOpen() == 0) {
                this.resolveContent();
                this.markDamaged();
            }
            LOG.debug((Object)((this.getSpecification().isOpen() ? "close" : "open") + " node " + this.getContent().getNaked()));
            if (this.canOpen() == 1) {
                View newView = this.replaceWithSpecification.createView(this.getContent(), this.getViewAxis());
                this.getParent().replaceView(this.getView(), newView);
            }
        } else if (y < this.top && x > this.left) {
            if (this.canOpen() == 0) {
                this.resolveContent();
                this.markDamaged();
            }
            this.selectNode();
        } else {
            super.firstClick(click);
        }
    }

    public int getBaseline() {
        return this.wrappedView.getBaseline() + this.baseline;
    }

    public Size getRequiredSize(Size maximumSize) {
        Size size = super.getRequiredSize(maximumSize);
        size.ensureWidth(this.left + HPADDING + this.icon.getSize().getWidth() + this.text.getSize().getWidth() + HPADDING + this.right);
        return size;
    }

    public void objectActionResult(Naked result, Location at) {
        NakedObject target;
        OneToManyField internalCollectionContent;
        OneToManyAssociation field;
        Consent about;
        if (this.getContent() instanceof OneToManyField && result instanceof NakedObject && (about = (field = (internalCollectionContent = (OneToManyField)this.getContent()).getOneToManyAssociation()).isValidToAdd(target = ((ObjectContent)this.getParent().getContent()).getObject(), (NakedObject)result)).isAllowed()) {
            field.addElement(target, (NakedObject)result);
        }
        super.objectActionResult(result, at);
    }

    private void resolveContent() {
        Naked parent = this.getParent().getContent().getNaked();
        if (!(parent instanceof NakedObject)) {
            parent = this.getParent().getParent().getContent().getNaked();
        }
        if (this.getContent() instanceof FieldContent) {
            NakedObjectField field = ((FieldContent)this.getContent()).getField();
            NakedObjectsContext.getObjectPersistor().resolveField((NakedObject)parent, field);
        } else if (this.getContent() instanceof CollectionContent) {
            NakedObjectsContext.getObjectPersistor().resolveImmediately((NakedObject)parent);
        } else if (this.getContent() instanceof CollectionElement) {
            NakedObjectsContext.getObjectPersistor().resolveImmediately((NakedObject)this.getContent().getNaked());
        }
    }

    public void secondClick(Click click) {
        int x = click.getLocation().getX();
        int y = click.getLocation().getY();
        if (y < this.top && x > this.left) {
            if (this.canOpen() == 0) {
                this.resolveContent();
                this.markDamaged();
            }
            Location location = this.getAbsoluteLocation();
            location.translate(click.getLocation());
            View openWindow = Toolkit.getViewFactory().createWindow(this.getContent());
            openWindow.setLocation(location);
            this.getWorkspace().addView(openWindow);
        } else {
            super.secondClick(click);
        }
    }

    private void selectNode() {
        TreeBrowserFrame axis = (TreeBrowserFrame)this.getViewAxis();
        if (axis.getSelectedNode() != this.getView()) {
            LOG.debug((Object)("node selected " + this.getContent().getNaked()));
            axis.setSelectedNode(this.getView());
        }
    }

    public String toString() {
        return this.wrappedView.toString() + "/TreeNodeBorder";
    }

    public ViewAreaType viewAreaType(Location mouseLocation) {
        Bounds bounds = new Bounds(this.left + 1, 0, this.getSize().getWidth() - this.left - 13, this.top);
        if (bounds.contains(mouseLocation)) {
            return ViewAreaType.CONTENT;
        }
        return super.viewAreaType(mouseLocation);
    }

    public void viewMenuOptions(UserActionSet options) {
        super.viewMenuOptions(options);
        TreeDisplayRules.menuOptions(options);
        options.add(new AbstractUserAction("Select node"){

            public void execute(Workspace workspace, View view, Location at) {
                TreeNodeBorder.this.selectNode();
            }

            public String getDescription(View view) {
                return "Show this node in the right-hand pane";
            }
        });
        Naked object = this.getView().getContent().getNaked();
        ResolveState resolveState = ((NakedReference)object).getResolveState();
        if (object instanceof NakedReference && (resolveState.isGhost() || resolveState.isPartlyResolved())) {
            options.add(new AbstractUserAction("Load object"){

                public void execute(Workspace workspace, View view, Location at) {
                    TreeNodeBorder.this.resolveContent();
                }
            });
        }
    }

    private boolean withinBox(int x, int y) {
        return x >= 5 && x <= 14 && y >= (this.top - 9) / 2 && y <= (this.top + 9) / 2;
    }
}

