/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.dialog;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nos.client.dnd.ActionContent;
import org.nakedobjects.nos.client.dnd.BackgroundTask;
import org.nakedobjects.nos.client.dnd.BackgroundThread;
import org.nakedobjects.nos.client.dnd.ButtonAction;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.LabelAxis;
import org.nakedobjects.nos.client.dnd.ObjectParameter;
import org.nakedobjects.nos.client.dnd.ParameterContent;
import org.nakedobjects.nos.client.dnd.SubviewSpec;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.ValueContent;
import org.nakedobjects.nos.client.dnd.ValueParameter;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewFactory;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractButtonAction;
import org.nakedobjects.nos.client.dnd.action.CancelAction;
import org.nakedobjects.nos.client.dnd.border.ButtonBorder;
import org.nakedobjects.nos.client.dnd.border.DialogBorder;
import org.nakedobjects.nos.client.dnd.border.DroppableLabelBorder;
import org.nakedobjects.nos.client.dnd.border.IconBorder;
import org.nakedobjects.nos.client.dnd.border.LabelBorder;
import org.nakedobjects.nos.client.dnd.builder.AbstractCompositeViewSpecification;
import org.nakedobjects.nos.client.dnd.builder.StackLayout;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.view.dialog.ActionDialogFocusManager;
import org.nakedobjects.nos.client.dnd.view.dialog.ActionFieldBuilder;

public class ActionDialogSpecification
extends AbstractCompositeViewSpecification {
    private static final Logger LOG = Logger.getLogger(ActionDialogSpecification.class);

    public ActionDialogSpecification() {
        this.builder = new StackLayout(new ActionFieldBuilder(new DialogFormSubviews()));
    }

    public boolean canDisplay(Content content) {
        return content instanceof ActionContent;
    }

    public View createView(Content content, ViewAxis axis) {
        ButtonAction[] actions = new ButtonAction[]{new ExecuteAndCloseAction(), new CancelAction()};
        View container = super.createView(content, new LabelAxis());
        ButtonBorder buttonBorder = new ButtonBorder(actions, new IconBorder(container));
        DialogBorder dialog = new DialogBorder(buttonBorder, false);
        dialog.setFocusManager(new ActionDialogFocusManager(buttonBorder));
        return dialog;
    }

    public String getName() {
        return "Action Dialog";
    }

    private static class ExecuteAndCloseAction
    extends ExecuteAction {
        public ExecuteAndCloseAction() {
            super("OK");
        }

        public void execute(Workspace workspace, View view, Location at) {
            LOG.debug((Object)("executing action " + this));
            view.dispose();
            LOG.debug((Object)"  ... disposed view, now executing");
            super.execute(workspace, view, at);
            view.getViewManager().setKeyboardFocus(workspace);
        }

        protected void move(Location at) {
        }
    }

    private static class ExecuteAction
    extends AbstractButtonAction {
        public ExecuteAction() {
            this("Apply");
        }

        public ExecuteAction(String name) {
            super(name, true);
        }

        public Consent disabled(View view) {
            View[] subviews = view.getSubviews();
            StringBuffer missingFields = new StringBuffer();
            StringBuffer invalidFields = new StringBuffer();
            for (int i = 0; i < subviews.length; ++i) {
                String parameterName;
                View field = subviews[i];
                ParameterContent content = (ParameterContent)field.getContent();
                if (content.isRequired() && (content.getNaked() == null || content.getNaked() instanceof NakedValue && ((NakedValue)content.getNaked()).isEmpty())) {
                    parameterName = content.getParameterName();
                    if (missingFields.length() > 0) {
                        missingFields.append(", ");
                    }
                    missingFields.append(parameterName);
                    continue;
                }
                if (!field.getState().isInvalid()) continue;
                parameterName = content.getParameterName();
                if (invalidFields.length() > 0) {
                    invalidFields.append(", ");
                }
                invalidFields.append(parameterName);
            }
            if (missingFields.length() > 0) {
                return new Veto("Fields needed: " + missingFields);
            }
            if (invalidFields.length() > 0) {
                return new Veto("Invalid fields: " + invalidFields);
            }
            ActionContent actionContent = (ActionContent)view.getContent();
            return actionContent.disabled();
        }

        public void execute(final Workspace workspace, final View view, Location at) {
            BackgroundTask task = new BackgroundTask(){

                public void execute() {
                    ActionContent actionContent = (ActionContent)view.getContent();
                    Naked result = actionContent.execute();
                    LOG.debug((Object)("action invoked with result " + result));
                    if (result != null) {
                        NakedCollection collection;
                        Location dialogLocation = view.getAbsoluteLocation();
                        ExecuteAction.this.move(dialogLocation);
                        if (result instanceof NakedCollection && (collection = (NakedCollection)result).size() == 1) {
                            result = collection.firstElement();
                        }
                        View newView = workspace.addOpenViewFor(result, dialogLocation);
                        view.getViewManager().setKeyboardFocus(newView);
                    }
                    view.getViewManager().disposeUnneededViews();
                    view.getFeedbackManager().showMessagesAndWarnings();
                }

                public String getName() {
                    return ((ActionContent)view.getContent()).getActionName();
                }

                public String getDescription() {
                    return "Running action " + this.getName() + " on  " + view.getContent().getNaked();
                }
            };
            LOG.debug((Object)("  ... created task " + task));
            BackgroundThread.run(view, task);
        }

        protected void move(Location at) {
            at.move(30, 60);
        }
    }

    private static class DialogFormSubviews
    implements SubviewSpec {
        private DialogFormSubviews() {
        }

        public View createSubview(Content content, ViewAxis axis) {
            if (content instanceof ValueParameter) {
                ViewFactory factory = Toolkit.getViewFactory();
                ViewSpecification specification = factory.getValueFieldSpecification((ValueContent)content);
                return specification.createView(content, axis);
            }
            if (content instanceof ObjectParameter) {
                ViewFactory factory = Toolkit.getViewFactory();
                ViewSpecification specification = factory.getIconizedSubViewSpecification(content);
                return specification.createView(content, axis);
            }
            return null;
        }

        public View decorateSubview(View fieldView) {
            if (fieldView.getContent() instanceof ObjectParameter) {
                return DroppableLabelBorder.createObjectParameterLabelBorder(fieldView);
            }
            return LabelBorder.createValueParameterLabelBorder(fieldView);
        }
    }
}

