/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.dialog;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nos.client.dnd.ActionContent;
import org.nakedobjects.nos.client.dnd.CompositeViewSpecification;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ObjectParameter;
import org.nakedobjects.nos.client.dnd.ParameterContent;
import org.nakedobjects.nos.client.dnd.SubviewSpec;
import org.nakedobjects.nos.client.dnd.ValueParameter;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.builder.AbstractViewBuilder;
import org.nakedobjects.nos.client.dnd.content.ObjectParameterImpl;
import org.nakedobjects.nos.client.dnd.view.simple.CompositeView;

public class ActionFieldBuilder
extends AbstractViewBuilder {
    private static final Logger LOG = Logger.getLogger(ActionFieldBuilder.class);
    private SubviewSpec subviewDesign;

    public ActionFieldBuilder(SubviewSpec subviewDesign) {
        this.subviewDesign = subviewDesign;
    }

    public void build(View view) {
        Assert.assertEquals((Object)view.getView(), (Object)view);
        ActionContent actionContent = (ActionContent)view.getContent();
        if (view.getSubviews().length == 0) {
            this.newBuild(view, actionContent);
        } else {
            this.updateBuild(view, actionContent);
        }
    }

    public View createCompositeView(Content content, CompositeViewSpecification specification, ViewAxis axis) {
        return new CompositeView(content, specification, axis);
    }

    private View createFieldView(View view, ParameterContent parameter) {
        View fieldView = this.subviewDesign.createSubview(parameter, view.getViewAxis());
        if (fieldView == null) {
            throw new NakedObjectRuntimeException("All parameters must be shown");
        }
        return fieldView;
    }

    public View decorateSubview(View subview) {
        return this.subviewDesign.decorateSubview(subview);
    }

    private void newBuild(View view, ActionContent actionContent) {
        LOG.debug((Object)("build new view " + view + " for " + actionContent));
        int noParameters = actionContent.getNoParameters();
        View focusOn = null;
        for (int f = 0; f < noParameters; ++f) {
            ParameterContent parameter = actionContent.getParameterContent(f);
            View fieldView = this.createFieldView(view, parameter);
            View decoratedSubview = this.decorateSubview(fieldView);
            view.addView(decoratedSubview);
            if (focusOn != null || !(parameter instanceof ValueParameter) || !fieldView.canFocus()) continue;
            focusOn = decoratedSubview;
        }
        if (focusOn != null) {
            view.getViewManager().setKeyboardFocus(focusOn);
        }
    }

    private void updateBuild(View view, ActionContent actionContent) {
        LOG.debug((Object)("rebuild view " + view + " for " + actionContent));
        View[] subviews = view.getSubviews();
        for (int i = 0; i < subviews.length; ++i) {
            View subview = subviews[i];
            Content content = subview.getContent();
            Naked subviewsObject = subview.getContent().getNaked();
            Naked invocationsObject = ((ActionContent)view.getContent()).getParameterObject(i);
            if (content instanceof ObjectParameter) {
                if (subviewsObject == invocationsObject) continue;
                ObjectParameterImpl parameter = new ObjectParameterImpl((ObjectParameterImpl)content, (NakedObject)invocationsObject);
                View fieldView = this.createFieldView(view, parameter);
                view.replaceView(subview, this.decorateSubview(fieldView));
                continue;
            }
            subview.refresh();
        }
    }
}

