/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.field;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.util.NotImplementedException;
import org.nakedobjects.nos.client.dnd.BackgroundTask;
import org.nakedobjects.nos.client.dnd.BackgroundThread;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.InternalDrag;
import org.nakedobjects.nos.client.dnd.KeyboardAction;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.ValueContent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Padding;
import org.nakedobjects.nos.client.dnd.view.field.ClearValueOption;
import org.nakedobjects.nos.client.dnd.view.field.CopyValueOption;
import org.nakedobjects.nos.client.dnd.view.field.PasteValueOption;
import org.nakedobjects.nos.client.dnd.view.simple.AbstractView;

public abstract class AbstractField
extends AbstractView {
    protected static final int TEXT_WIDTH = 20;
    private boolean identified;

    protected AbstractField(Content content, ViewSpecification design, ViewAxis axis) {
        super(content, design, axis);
    }

    public boolean canFocus() {
        return this.canChangeValue().isAllowed();
    }

    void clear() {
    }

    void copyToClipboard() {
    }

    public Consent canChangeValue() {
        ValueContent cont = (ValueContent)this.getContent();
        return cont.isEditable();
    }

    public void drag(InternalDrag drag) {
    }

    public void dragCancel(InternalDrag drag) {
    }

    public View dragFrom(Location location) {
        return null;
    }

    public void dragTo(InternalDrag drag) {
    }

    public void draw(Canvas canvas) {
        if (this.getState().isActive()) {
            canvas.clearBackground(this, Toolkit.getColor("identified"));
        }
        if (this.getState().isOutOfSynch()) {
            canvas.clearBackground(this, Toolkit.getColor("out-of-sync"));
        }
        if (this.getState().isInvalid()) {
            canvas.clearBackground(this, Toolkit.getColor("invalid"));
        }
        super.draw(canvas);
    }

    public void editComplete() {
    }

    public void entered() {
        super.entered();
        this.identified = true;
        Consent changable = this.canChangeValue();
        if (changable.isVetoed()) {
            this.getFeedbackManager().setViewDetail(changable.getReason());
        }
        this.markDamaged();
    }

    public void exited() {
        super.exited();
        this.identified = false;
        this.markDamaged();
    }

    public boolean getIdentified() {
        return this.identified;
    }

    public Padding getPadding() {
        return new Padding(0, 0, 0, 0);
    }

    public View getRoot() {
        throw new NotImplementedException();
    }

    String getSelectedText() {
        return "";
    }

    public boolean hasFocus() {
        return this.getViewManager().hasFocus(this.getView());
    }

    public boolean indicatesForView(Location mouseLocation) {
        return false;
    }

    public void keyPressed(KeyboardAction key) {
    }

    public void keyReleased(int keyCode, int modifiers) {
    }

    public void keyTyped(char keyCode) {
    }

    public void contentMenuOptions(UserActionSet options) {
        options.add(new CopyValueOption(this));
        options.add(new PasteValueOption(this));
        options.add(new ClearValueOption(this));
        if (this.getView().getSpecification().isReplaceable()) {
            this.replaceOptions(Toolkit.getViewFactory().valueViews(this.getContent(), this), options);
        }
        super.contentMenuOptions(options);
        options.setColor(Toolkit.getColor("background.value-menu"));
    }

    protected final void initiateSave() {
        BackgroundThread.run(this, new BackgroundTask(){

            public void execute() {
                AbstractField.this.save();
                AbstractField.this.getParent().updateView();
                AbstractField.this.invalidateLayout();
            }

            public String getName() {
                return "Save field";
            }

            public String getDescription() {
                return "Saving " + AbstractField.this.getContent().windowTitle();
            }
        });
    }

    protected abstract void save();

    protected void saveValue(NakedObject value) {
        this.parseEntry(value.titleString());
    }

    protected void parseEntry(String entryText) {
        ValueContent content = (ValueContent)this.getContent();
        content.parseTextEntry(entryText);
        content.entryComplete();
    }

    void pasteFromClipboard() {
    }

    public String toString() {
        String cls = this.getClass().getName();
        Naked naked = this.getContent().getNaked();
        return cls.substring(cls.lastIndexOf(46) + 1) + this.getId() + " [location=" + this.getLocation() + ",object=" + (naked == null ? "" : naked.getObject()) + "]";
    }

    public ViewAreaType viewAreaType(Location mouseLocation) {
        return ViewAreaType.INTERNAL;
    }

    public int getBaseline() {
        return Toolkit.defaultBaseline();
    }
}

